import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { RadioButtonComponent } from '../radio-button/radio-button.component';
import { StoreSelectionTypeComponent } from './store-selection-type.component';
import { CardComponent } from '../card/card.component';
import { DialogService } from "../../services/dialog/dialog.service";
import { Component, NO_ERRORS_SCHEMA } from '@angular/core';
import { FormsModule, FormBuilder } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA, MatDialog } from '@angular/material/dialog';
import { ApiService } from '../../services/api/api.service';
const mockMatDialogRef = { close: jest.fn() };
const mockSubscribe = jest.fn();

@Component({
  selector: 'bre-mock-component',
  template: `<bre-store-selection-type [storesHierarchy]="[{}]"></bre-store-selection-type>`
})
export class StoreSelectionTypeMockComponent {
  StoreSelectionTypeComponent;
  setStoreSelectionType() { }
}
describe('StoreSelectionTypeComponent', () => {
  let component: StoreSelectionTypeComponent;
  let fixture: ComponentFixture<StoreSelectionTypeComponent>;
  let fixture1: ComponentFixture<StoreSelectionTypeMockComponent>;
  let component1: StoreSelectionTypeComponent;
  const mockOpen = jest.fn((content, config) => ({ afterClosed: () => ({ subscribe: mockSubscribe }) }));

  class MockMatDialog {
    open(content, config) {
      return mockOpen(content, config);
    }
  }
  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [StoreSelectionTypeComponent, RadioButtonComponent, CardComponent],
      providers: [DialogService,  {provide: MatDialog} ],
      imports: [FormsModule],
      schemas: [NO_ERRORS_SCHEMA]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(StoreSelectionTypeComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should create', () => {
    spyOn(component, 'setStoreSelectionType').and.callThrough();
    component.setStoreSelectionType('all');
    expect(component.setStoreSelectionType).toHaveBeenCalled();
  });
});
