import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { StoreSelectComponent } from './store-select.component';
import { NO_ERRORS_SCHEMA, CUSTOM_ELEMENTS_SCHEMA } from '@angular/core';
import { FormsModule, FormBuilder } from '@angular/forms';
import { ScopeService } from "../../services/scope/scope.service";
import { ApiService } from '../../services/api/api.service';
import { HttpClient, HttpHandler } from '@angular/common/http';
import { HttpClientTestingModule } from '@angular/common/http/testing';

describe('StoreSelectComponent', () => {
  let component: StoreSelectComponent;
  let fixture: ComponentFixture<StoreSelectComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ StoreSelectComponent ],
      schemas: [CUSTOM_ELEMENTS_SCHEMA, NO_ERRORS_SCHEMA],
      imports: [ HttpClientTestingModule ],
      providers: [FormBuilder, ScopeService, ApiService, HttpClient, HttpHandler]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(StoreSelectComponent);
    component = fixture.componentInstance;
    component.hierarchyScopeData = [
      {
        "coopNodeId": null,
        "created": "2022-09-23T12:00:49.000+00:00",
        "globalStores": {
          "stores": [{}]
        },
        "hierarchyLevel": 3000,
        "id": 1,
        "ipAddress": null,
        "marketNodeId": null,
        "marketSelected": false,
        "marketSelectedDefault": false,
        "nodeName": "US",
        "regionNodeId": null,
        "regions": [
          {
            "coopNodeId": null,
            "created": "2022-09-23T12:00:50.000+00:00",
            "hierarchyLevel": 3100,
            "id": 21,
            "ipAddress": null,
            "marketName": "US",
            "marketNodeId": 1,
            "nodeName": "QA Test Region",
            "regionNodeId": null,
            "regionSelected": true,
            "regionSelectedDefault": false,
            "restaurantNo": null,
            "updated": "2022-09-23T12:00:50.000+00:00",
            "coops": [
              {
                "coopNodeId": null,
                "coopSelected": true,
                "coopSelectedDefault": false,
                "created": "2022-09-23T12:00:52.000+00:00",
                "hierarchyLevel": 3200,
                "id": 91,
                "ipAddress": null,
                "marketNodeId": 1,
                "nodeName": "QA Test COOP",
                "regionNodeId": 21,
                "restaurantNo": null,
                "updated": "2022-09-23T12:00:52.000+00:00",
                "stores": [
                  {
                    "attributes": {
                      "coopNodeId": 91,
                      "ipAddress": null,
                      "nodeName": "AOT Black Widow",
                      "regionName": "QA Test Region",
                      "regionNodeId": 21,
                      "restaurantNo": "99093"
                    },
                    "id": "38634",
                    "storeSelected": true,
                    "storeSelectedDefault": false,
                    "type": "restaurantDetails"
                  }
                ]
              }
            ]
          }
        ],
        "restaurantNo": null,
        "updated": "2022-09-23T12:00:49.000+00:00"
      }
    ];
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should test selectRestaurant', () => {
    spyOn(component, 'selectRestaurant').and.callThrough();
    let e ={ 
      "checkboxChecked": true
    }
    component.selectRestaurant(e, 0, 0, 0);
    expect(component.selectRestaurant).toBeCalled();
  });

  it('should test selectAllCoop', () => {
    spyOn(component, 'selectAllCoop').and.callThrough();
    let e ={ 
      "checkboxChecked": true
    }
    component.selectAllCoop(e, 0, 0);
    expect(component.selectAllCoop).toBeCalled();
  });

  it('should test selectAllStores', () => {
    spyOn(component, 'selectAllStores').and.callThrough();
    component.selectAllStores();
    expect(component.selectAllStores).toBeCalled();
  });
});
