import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { StatusPillComponent } from './status-pill.component';
import { Component } from '@angular/core';

@Component({
  selector: 'bre-mock',
  template: '<bre-status-pill type="green">FooBar</bre-status-pill>'
})
class MockComponent { }

describe('StatusPillComponent', () => {
  let component: MockComponent;
  let fixture: ComponentFixture<MockComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [StatusPillComponent, MockComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MockComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should take property type of "complete" and return a complete status pill', () => {
    expect(fixture.nativeElement.querySelector('.green').innerHTML).toEqual('FooBar')
  })
});
