import { Component, Input, Output, EventEmitter } from "@angular/core";

@Component({
  selector: "bre-split-button",
  templateUrl: "./split-button.component.html",
  styleUrls: ["./split-button.component.scss"],
})
export class SplitButtonComponent {
  @Input() buttonClass: string;
  @Input() dateSelected = new Date();
  @Input() label: string = "Click";
  @Input() isLoading: boolean = false;
  @Input() disabled: boolean = false;
  @Input() maximumDate: Date;
  @Input() icon: string;
  @Input() type: string;

  minimumDate = new Date();

  @Output() confirmClicked: EventEmitter<Date> = new EventEmitter();
  constructor() {
  }

  confirm() {
    this.confirmClicked.emit(this.dateSelected);
  }

  dateSelectedChanged(event) {
    this.dateSelected = event;
  }

  preventClose($event) {
    $event.stopPropagation();
  }
}
