import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ReactiveFormsModule } from '@angular/forms';
import { MatMenuModule } from '@angular/material/menu';
import { ButtonModule } from 'primeng/button';
import { CalendarModule } from 'primeng/calendar';
import { ProgressSpinnerModule } from 'primeng/progressspinner';
import { ButtonComponent } from '../button/button.component';
import { CalendarComponent } from '../calendar/calendar.component';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component';
import { StatusPillComponent } from '../status-pill/status-pill.component';
import { TooltipDirective } from '../tooltip/tooltip.directive';

import { SplitButtonComponent } from './split-button.component';

describe('SplitButtonComponent', () => {
  let component: SplitButtonComponent;
  let fixture: ComponentFixture<SplitButtonComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ SplitButtonComponent, ButtonComponent, IconButtonComponent, CalendarComponent, ControlLabelComponent, TooltipDirective, PopoverMenuButtonComponent, StatusPillComponent ],
      imports: [ ReactiveFormsModule, ProgressSpinnerModule, MatMenuModule, ButtonModule, CalendarModule ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SplitButtonComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should emit an event on clicking confirm', () => {
    const spy = spyOn(component.confirmClicked, 'emit');

    component.confirm();
    expect(spy).toHaveBeenCalledWith(component.dateSelected);
  });

  it('should allow for selecting a date', () => {
    const newDate = new Date(2000,12,25);

    component.dateSelectedChanged(newDate);
    expect(component.dateSelected).toEqual(newDate);
  });

  it('should stop event propagation', () => {
    const mockEvent = { stopPropagation: () => {} };
    const spy = spyOn(mockEvent, 'stopPropagation');
    component.preventClose(mockEvent)
    expect(spy).toHaveBeenCalled();
  });
});
