import { Component, Inject, ViewEncapsulation } from "@angular/core";
import { FormBuilder, FormGroup } from "@angular/forms";
import { MAT_DIALOG_DATA } from "@angular/material/dialog";
import { ScopeService } from "../../services/scope/scope.service";
import { debounceTime, distinctUntilChanged } from 'rxjs/operators';
// import { DialogData } from '../../interfaces/deployments.interface'; 

@Component({
  selector: 'bre-selected-restaurants-dialog',
  templateUrl: './selected-restaurants-dialog.component.html',
  styleUrls: ['./selected-restaurants-dialog.component.scss']
})
export class SelectedRestaurantsDialogComponent {
  allMarketRegions = [];
  filteredMarketRegions = [];
  searchForm: FormGroup;
  dialogData: any;
  filteredRestaurants;
  selectedApps = [{
    label: 'All Applications',
    value: 'All'
  }];
  selectedProducts = [{
    label: 'All Products',
    value: 'All'
  }];
  selectedFilters = {
    keyword: "",
    deploymentId: "",
    productId: "",
    applicationName: "",
    status: ""
  };
  statusList = [
    { label: "All", value: "All" },
    { label: "Completed", value: "Completed" },
    { label: "In-Progress", value: "inProgress" },
    { label: "Failed", value: "Failed" },
  ];
  selectedScopeHierarchyPopup: { nodeName: any; id: any; regions: { nodeName: any; regionNodeId: any; restaurantNo: any; coopName: any; coopNodeId: any; coops: { nodeName: any; regionNodeId: any; restaurantNo: any; coopName: any; coopNodeId: any; stores: any; }[]; }[]; }[];
  marketName: string;
  selectedCoops: {nodeName: string}[];
  selRegions: {nodeName: string}[];
  restaurantStatus: {restaurantId: string, status: string}[];
  showLoader: boolean = false;
  existingFilters = {
    keyword: "",
    deploymentId: "",
    productId: "",
    applicationName: "",
    status: ""
  };
  originalData;
  allApps;

  constructor(
    @Inject(MAT_DIALOG_DATA) protected data,
    private scopeService: ScopeService,
    private fb: FormBuilder
  ) {
    this.dialogData = data;
    this.restaurantStatus = data?.restaurantStatus;
    this.selectedFilters.deploymentId = data?.deploymentId;
    if (this.dialogData?.appData) {
      this.originalData = [...this.data.originalData];
      if (data.isProductBundle || data.deploymentType?.toLowerCase() === 'product') {
        this.selectedProducts = this.dialogData?.appData?.dockerApplications?.reduce((acc, row, currentIndex) => {
          if (currentIndex === 0) acc.push({ label: 'All Products', value: 'All' });
          if (row.productName) acc.push({ label: row.productName ? row.productName : "", value: row.productId ? row.productId : "" });
          row?.dockerApplications?.map(app => {
            app.productId = row.productId;
            this.selectedApps?.push({
              label: app.applicationName,
              value: app.applicationName
            })
          })
          return acc;
        }, []);
        this.allApps = [...this.selectedApps];
      } else {
        this.selectedApps = this.dialogData?.appData?.reduce((acc, row, currentIndex) => {
          if (currentIndex === 0) acc.push({ label: 'All Applications', value: 'All' });
          acc.push({ label: row.name, value: row.name });
          return acc;
        }, []);
      }
    }

    if (this.data.storesHierarchy?.length && !this.data.showData) {
      const selectedScopesHierarchy = this.scopeService.getSelectedScopesHierarchy(this.data.storesHierarchy, data.allSelected);
      this.allMarketRegions = selectedScopesHierarchy.length ? selectedScopesHierarchy[0]?.regions : null;
       if(selectedScopesHierarchy.length) this.filteredMarketRegions = [...this.allMarketRegions];
    } else {
      this.allMarketRegions = this.data.storesHierarchy?.length ? this.data.storesHierarchy[0]?.regions : null;
      if(this.data.storesHierarchy?.length) this.filteredMarketRegions = [...this.allMarketRegions];
    }
    this.searchForm = this.fb.group({
      searchKeyword: "",
      product: "",
      application: "",
      status: ""
    });

    this.searchForm.valueChanges.pipe(debounceTime(200), distinctUntilChanged()).subscribe(() => {

      // Search for store
      if (this.searchForm?.value?.searchKeyword !== this.existingFilters.keyword) {
        this.selectedFilters.keyword = this.searchForm?.value?.searchKeyword;
        if (!this.dialogData.isDetailsPage){
          this.filterHierarchyByStore(this.searchForm?.value?.searchKeyword, false);
        }else{
          this.filterFromDeploymentHistory();
        }         
      }
      else if(this.searchForm?.value?.searchKeyword === '') {
        this.filteredMarketRegions = this.allMarketRegions;
      } else {
        this.selectedFilters.keyword = ""
      }


      if (this.searchForm?.value?.application !== this.existingFilters.applicationName) {
        if(this.data?.isProductBundle || this.data?.deploymentType?.toLowerCase() === 'product'){
          if(this.searchForm?.value?.application === 'All'){
            this.searchForm.patchValue({product: 'All'});
          }else{
            this.data?.appData?.dockerApplications?.map(app => {
              let selectedProdId = app?.dockerApplications?.find(item => {
                  return item?.applicationName === this.searchForm?.value?.application
                })
                if(selectedProdId) this.searchForm.patchValue({product: selectedProdId?.productId});
               
            })
          }      
        }
        this.selectedFilters.applicationName = this.searchForm?.value?.application;
        this.filterFromDeploymentHistory();
      }
      if (this.searchForm?.value?.product !== this.existingFilters.productId) {
        let apps = [];
        if(this.searchForm?.value?.product?.toLowerCase() !== 'all'){
          let apps = [];
          this.data?.appData?.dockerApplications?.find(app => {
            return app.productId === this.searchForm?.value?.product
          })?.dockerApplications?.map(dockerApp => {
            apps.push({
              label: dockerApp?.applicationName,
              value: dockerApp?.applicationName
            })
          })
          this.selectedApps = apps;
        }else{
          this.searchForm?.patchValue({
            application: ""
          })
          this.selectedApps = this.allApps;
        }
        this.selectedFilters.productId = this.searchForm?.value?.product;
        this.filterFromDeploymentHistory();
      }
      if (this.searchForm?.value?.status !== this.existingFilters?.status) {
        this.selectedFilters.status = this.searchForm?.value?.status;
        this.filterFromDeploymentHistory();
      }

    });
  }

  public getProductDeploymentStatus(deploymentHistory) {
    let completedArr = [];
    let inProgressArr = [];
    let failedArr = [];
    let restaurants = [];
    let scheduledArr = [];
    let completedCount = 0;
    let failedCount = 0;
    let inProgressCount = 0;
    let scheduledCount = 0;
    restaurants = deploymentHistory?.included?.filter(item => item?.type === 'restaurants')?.map(res => res?.id);
    deploymentHistory?.data?.map(item => {
      switch (item?.attributes?.status) {
        case 'Completed': {
          completedArr.push(item?.relationships?.restaurant?.data?.id);
          break;
        }
        case 'Failed': {
          failedArr.push(item?.relationships?.restaurant?.data?.id);
          break;
        }
        case 'In-Progress': {
          inProgressArr.push(item?.relationships?.restaurant?.data?.id);
          break;
        }
        case 'Already-Present': {
          completedArr.push(item?.relationships?.restaurant?.data?.id);
          break;
        }
        case 'Scheduled': {
          scheduledArr.push(item?.relationships?.restaurant?.data?.id);
          break;
        }
      }
    })
    let restaurantWithStatus = [];
    restaurants?.map(item => {
      if (scheduledArr.includes(item)) {
        scheduledCount++;
      } else if (failedArr.includes(item)) {
        failedCount++;
        restaurantWithStatus.push({
          "restaurantId": item,
          "status": "failed"
        });
      } else if (inProgressArr.includes(item)) {
        inProgressCount++;
        restaurantWithStatus.push({
          "restaurantId": item,
          "status": "inProgress"
        });
      } else if (completedArr.includes(item)) {
        completedCount++;
        restaurantWithStatus.push({
          "restaurantId": item,
          "status": "completed"
        });
      }
    });
    return restaurantWithStatus;
  }

  /**
   * Filter restaurants from deployment history based on selected filters.
   */
  filterFromDeploymentHistory() {
    if (this.selectedFilters.applicationName !== this.existingFilters.applicationName || this.selectedFilters.productId !== this.existingFilters.productId || this.selectedFilters.status !== this.existingFilters.status) {
      this.showLoader = true;
     
      this.scopeService.getDeploymentHistory(this.selectedFilters).then(res => {
        this.showLoader = false;
        this.filteredRestaurants = res?.included?.filter(item => { return item.type?.toLowerCase() === 'restaurants' });       
        this.restaurantStatus = this.getProductDeploymentStatus(res);
        if (this.filteredRestaurants) {
          let filteredResult = this.originalData?.filter(item => {
            const str = `${item?.attributes?.restaurantNo} - ${item?.attributes?.nodeName}`;
            return this.filteredRestaurants?.find(restaurant => { return item.id === restaurant.id && str.toLowerCase().indexOf(this.searchForm?.value?.searchKeyword.toLowerCase()) > -1 })
          })
          this.searchResult(filteredResult);
        } else {
          this.filteredMarketRegions = []
        }
      })
    } else {
      let filtered;
      if (this.searchForm?.value?.searchKeyword) {        
        if(this.filteredRestaurants){
          filtered = this.originalData?.filter(item => {
            const str = `${item?.attributes?.restaurantNo} - ${item?.attributes?.nodeName}`;
            return this.filteredRestaurants.find(restaurant => { return item.id === restaurant.id && str.toLowerCase().indexOf(this.searchForm?.value?.searchKeyword.toLowerCase()) > -1 })
          })
        }else{
          filtered = this.originalData?.filter(store => {
            const str = `${store?.attributes?.restaurantNo} - ${store?.attributes?.nodeName}`;
            return str.toLowerCase().indexOf(this.searchForm?.value?.searchKeyword.toLowerCase()) > -1;
          })
        }        
      } else {
        if(this.filteredRestaurants){
          filtered = this.originalData?.filter(item => {
            return this.filteredRestaurants?.find(restaurant => { return item.id === restaurant.id })
          })
        }else{
          filtered = [...this.data.originalData];
        }
      }
      this.searchResult(filtered);
    }
    this.existingFilters = Object.assign({}, this.selectedFilters);
  }
  /**
   * @param filteredResult
   * return search result reshaped to market,region,coop,store 
   */
  searchResult(filteredResult) {
    if (filteredResult.length) {
      let selRegions = filteredResult?.map(item => item.attributes.regionName)
      this.selRegions = selRegions?.filter(function (item, pos) {
        return selRegions.indexOf(item) == pos;
      })?.map(item => item = {
        "nodeName": item
      });
      let regions = this.selRegions?.map((region: any) => {
        let val = filteredResult?.filter(item => item.attributes.regionName === region.nodeName)[0];
        return {
          "nodeName": val.attributes.regionName,
          "regionNodeId": val.attributes.regionNodeId,
          "restaurantNo": val.attributes.restaurantNo,
          "coopName": val.attributes.coopName,
          "coopNodeId": val.attributes.coopNodeId
        }
      });
      let selectedCoops = filteredResult?.map(item => item.attributes.coopName);
      this.selectedCoops = selectedCoops?.filter(function (item, pos) {
        return selectedCoops.indexOf(item) == pos;
      })?.map(item => item = {
        "nodeName": item
      });

      let coopsData = this.selectedCoops?.map((coop) => {
        let val = filteredResult?.filter(item => item.attributes.coopName === coop.nodeName)[0];
        return {
          "nodeName": val.attributes.regionName,
          "regionNodeId": val.attributes.regionNodeId,
          "restaurantNo": val.attributes.restaurantNo,
          "coopName": val.attributes.coopName,
          "coopNodeId": val.attributes.coopNodeId
        }
      });
      this.marketName = filteredResult[0]?.attributes.marketName;
      
      this.selectedScopeHierarchyPopup = [
        {
          nodeName: filteredResult[0]?.attributes.marketName,
          id: filteredResult[0].attributes.marketNodeId,
          regions: regions?.map((region) => {
            return {
              ...region,
              "coops": coopsData?.filter((coop) => {
                if (coop.regionNodeId === region.regionNodeId) {
                  return coop
                }
              })?.map(item => {
                return {
                  ...item,
                  "stores": filteredResult?.filter(store => store.attributes.coopNodeId === item.coopNodeId)?.map(restaurant => {
                    return {
                      ...restaurant,
                      status: !this.selectedFilters?.status || this.selectedFilters?.status?.toLowerCase() === 'all' ? this.restaurantStatus?.filter(val => val?.restaurantId?.toString() === restaurant?.id?.toString())[0]?.status : this.selectedFilters?.status?.toLowerCase()
                    }
                  })
                }
              })
            }
          })
        }
      ];
      this.filteredMarketRegions = [...this.selectedScopeHierarchyPopup][0]?.regions;
    } else {
      this.filteredMarketRegions = [];
    }
  }

  /**
   * Filters hierarchy by searched store
   * @param keyword search string for store name or number
   */
  filterHierarchyByStore(keyword: string, isStatusDropDown?) {
    this.filteredMarketRegions = this.allMarketRegions?.reduce(
      (accRegions, region) => {
        let filteredCoops, filteredStores;
        if (isStatusDropDown) {
          filteredCoops = region.coops?.reduce((accCoops, coop) => {
            filteredStores = keyword.toLowerCase() === 'all' ? coop?.stores : coop?.stores?.filter(store => store?.status === keyword)
            if (filteredStores?.length > 0) {
              return [
                ...accCoops,
                {
                  ...coop,
                  stores: filteredStores
                }
              ];
            }
            return accCoops;
          }, []);
        } else {
          filteredCoops = region.coops?.reduce((accCoops, coop) => {
            filteredStores = coop.stores?.filter((store) => {
              const str = `${store?.attributes?.restaurantNo} - ${store?.attributes?.nodeName}`;
              return str.toLowerCase().indexOf(keyword.toLowerCase()) > -1;
            });
            if (filteredStores?.length > 0) {
              return [
                ...accCoops,
                {
                  ...coop,
                  stores: filteredStores
                }
              ];
            }
            return accCoops;
          }, []);
        }

        if (filteredCoops?.length > 0) {
          return [
            ...accRegions,
            {
              ...region,
              coops: filteredCoops
            }
          ];
        }
        return accRegions;
      }, []
    );
  }
  /**
   * status drop down value captured for filtering.
   */
  statusFilter(event) {
    if (event.value?.toLowerCase() === "completed" || event.value?.toLowerCase() === "already-present") {
      event.value = "completed";
    } else if (event.value?.toLowerCase() === "in-progress") {
      event.value = "inProgress";
    } else if (event.value?.toLowerCase() === "scheduled") {
      event.value = "scheduled";
    } else if (event.value?.toLowerCase() === "failed") {
      event.value = "failed"
    }
    this.filterHierarchyByStore(event.value, true);
  }
}
