import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { InputComponent } from '../input/input.component';
import { ScopeService } from "../../services/scope/scope.service";
import { SelectedRestaurantsDialogComponent } from './selected-restaurants-dialog.component';
import { DropdownComponent } from '../dropdown/dropdown.component';
import { LoaderComponent } from '../loader/loader.component';
import { CardComponent } from '../card/card.component';
import { SearchableSelectComponent } from '../searchable-select/searchable-select.component';
import { DialogComponent } from '../../services/dialog/dialog.component';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { InputErrorMessageComponent } from '../input-error-message/input-error-message.component';
import { NO_ERRORS_SCHEMA } from '@angular/core';
import { StatusPillComponent } from '../status-pill/status-pill.component';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA, MatDialog } from '@angular/material/dialog';
import { ApiService } from '../../services/api/api.service';
import { HttpClient, HttpHandler } from '@angular/common/http';
import { HttpClientTestingModule } from '@angular/common/http/testing';
const mockMatDialogRef = { close: jest.fn() };
describe('SelectedRestaurantsDialogComponent', () => {
  let component: SelectedRestaurantsDialogComponent;
  let fixture: ComponentFixture<SelectedRestaurantsDialogComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [FormsModule, ReactiveFormsModule, HttpClientTestingModule],
      declarations: [StatusPillComponent, InputErrorMessageComponent, SelectedRestaurantsDialogComponent, InputComponent, DropdownComponent, LoaderComponent, CardComponent, SearchableSelectComponent, DialogComponent, ControlLabelComponent],
      providers: [{ provide: MAT_DIALOG_DATA, useValue: [] },
      { provide: MatDialogRef, useValue: mockMatDialogRef },
       ScopeService, ApiService, HttpClient, HttpHandler],
      schemas: [NO_ERRORS_SCHEMA]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SelectedRestaurantsDialogComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
});
