import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import {  DialogService } from "../../services/dialog/dialog.service";
import { SelectHierarchyComponent } from './select-hierarchy.component';
import { NO_ERRORS_SCHEMA } from '@angular/core';
import { HierarchyApiService } from "../../services/hierarchy/hierarchy-api.service";
import { ScopeService } from "../../services/scope/scope.service";
import { SelectedRestaurantsDialogComponent } from "../../components/selected-restaurants-dialog/selected-restaurants-dialog.component";
import { ApiService } from '../../services/api/api.service';
import { HttpClient, HttpHandler } from '@angular/common/http';
import { HttpClientTestingModule } from '@angular/common/http/testing';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { MatDialogRef, MAT_DIALOG_DATA, MatDialog } from '@angular/material/dialog';
const mockMatDialogRef = { close: jest.fn() };

describe('SelectHierarchyComponent', () => {
  let component: SelectHierarchyComponent;
  let fixture: ComponentFixture<SelectHierarchyComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [HttpClientTestingModule, FormsModule, ReactiveFormsModule],
      declarations: [ SelectHierarchyComponent ],
      providers: [ DialogService, { provide: MatDialog} ,ApiService, HierarchyApiService, ScopeService, SelectedRestaurantsDialogComponent, HttpClient, HttpHandler ],
      schemas: [NO_ERRORS_SCHEMA]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(SelectHierarchyComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
});
