import { Component, OnInit, Input, Output, EventEmitter } from '@angular/core';
import { SelectItem } from 'primeng/api';

@Component({
  selector: 'bre-searchable-dropdown',
  templateUrl: './searchable-dropdown.component.html',
  styleUrls: ['./searchable-dropdown.component.scss']
})
export class SearchableDropdownComponent implements OnInit {
  @Input() items: SelectItem[];
  @Input() label: string;
  @Input() filterPlaceholder: string = "Search...";

  @Input() value;
  @Output() valueChange = new EventEmitter<any>();

  ngOnInit(): void { }

  valueUpdated(event) {
    this.valueChange.emit(event.value);
  }
}
