import { Component, EventEmitter, Input, Output } from '@angular/core';

@Component({
  selector: 'bre-radio-core',
  templateUrl: './radio-button.component.html',
  styleUrls: ['./radio-button.component.scss']
})
export class RadioButtonComponent {
  @Input() radioName: string;
  @Input() radioLabel: string;
  @Input() value: string;
  @Input() radioId: string;
  @Input() isChecked: boolean;
  @Output() onRadioSelect: EventEmitter<string> = new EventEmitter();
  public radioSelected: string;

  public onItemChange(item) {
    this.onRadioSelect.emit(this.radioSelected);
  }
}
