import {
  Component,
  OnInit,
  OnChanges,
  Input,
  Output,
  EventEmitter,
  TemplateRef,
} from "@angular/core";
import { ActivatedRoute, Router } from "@angular/router";
import { QuickJumpViewLoadDataEvent } from "./quick-jump-load-data-event.interface";

@Component({
  selector: "bre-quick-jump",
  templateUrl: "./quick-jump.component.html",
  styleUrls: ["./quick-jump.component.scss"],
})
export class QuickJumpComponent implements OnInit, OnChanges {
  @Input() data: any[];
  @Input() itemTemplate: TemplateRef<HTMLElement>;
  @Output() onLoad: EventEmitter<QuickJumpViewLoadDataEvent> =
    new EventEmitter();
  @Input() dataLength: number;
  @Input() isLoading: boolean;
  @Input() initialRows: number;
  @Input() rowsPerScroll: number;
  @Input() error: number;
  @Input() animationWidth: string = "50px";
  @Input() animationHeight: string = "50px";
  @Input() showPrimaryOrSecondary: boolean;
  @Input() customizedHeader: boolean = false;

  private sum: number;
  public selected: boolean[] = [];

  constructor(private router: Router) {}

  ngOnInit(): void {
    // infinite scroll -> number of items ititially displayed
    this.sum = this.initialRows;
    this.onLoad.emit({ start: 0, end: this.sum });
  }

  ngOnChanges(changes): void {
    // if data length changes, reset the sum

    if (
      !!changes.dataLength &&
      changes.dataLength.previousValue != changes.dataLength.currentValue
    ) {
      this.sum = this.initialRows;
    }
  }

  onScroll(): void {
    let start = this.sum;

    if (this.dataLength - start > 5) {
      // number of items pulled in on scroll
      this.sum += this.rowsPerScroll;
      this.onLoad.emit({ start, end: this.sum });
    } else if (
      this.dataLength - start > 0 &&
      this.dataLength - start < this.rowsPerScroll
    ) {
      this.sum += this.dataLength - this.sum;
      this.onLoad.emit({ start, end: this.sum });
    }
  }
}
