import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { RouterTestingModule } from "@angular/router/testing";
import { Router } from "@angular/router";
import { Component, OnInit } from "@angular/core";
import { InfiniteScrollModule } from "ngx-infinite-scroll";
import { QuickJumpComponent } from "./quick-jump.component";
import { StatusPillComponent } from "../status-pill/status-pill.component";
import { LoaderComponent } from "../loader/loader.component";
import { LottieModule } from "ngx-lottie";

@Component({
  selector: "bre-mock",
  template: `
    <bre-quick-jump
      [data]="renderedData"
      [initialRows]="2"
      [rowsPerScroll]="5"
      [dataLength]="data.length"
      (onLoad)="addItems($event)"
      [itemTemplate]="customItemTemplate"
      [showPrimaryOrSecondary]="showPrimaryOrSecondary"
    >
      <ng-template #customItemTemplate let-item>
        <div
          (click)="onSelect(item)"
          [class.selected]="item === selectedItem"
          class="row"
        >
          <div class="col1">{{ item.code }}</div>
          <div class="col2">{{ item.status }}</div>
          <div class="col3">{{ item.name }}</div>
        </div>
      </ng-template>
    </bre-quick-jump>
  `
})
class MockComponent {
  public data = [
    {
      code: 1,
      name: "Salt",
      status: "complete"
    },
    {
      code: 2,
      name: "Pepper",
      status: "complete"
    },
    {
      code: 3,
      name: "Cheeseburger",
      status: "complete"
    }
  ];
  public renderedData: any[] = [];
  public selectedItem;

  constructor(private router: Router) {}

  ngOnInit(): void {}

  addItems(QuickJumpViewLoadDataEvent): void {
    this.renderedData.push(
      ...this.data.slice(
        QuickJumpViewLoadDataEvent.start,
        QuickJumpViewLoadDataEvent.end
      )
    );
  }

  onSelect(item): void {
    this.router.navigate(["/menu/edit/us/", `${item.code}`]);
    this.selectedItem = item;
  }
}

describe("QuickJumpComponent", () => {
  let component: MockComponent;
  let fixture: ComponentFixture<MockComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [RouterTestingModule, InfiniteScrollModule, LottieModule],
      declarations: [
        QuickJumpComponent,
        MockComponent,
        StatusPillComponent,
        LoaderComponent
      ]
    }).compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MockComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });

  it("should initially display a list of 2 menu items", () => {
    expect(fixture.nativeElement.querySelectorAll(".row").length).toEqual(2);
  });
});
