import { Component, Input, OnChanges, OnInit } from "@angular/core";

@Component({
  selector: "bre-progress-bar",
  templateUrl: "./progress-bar.component.html",
  styleUrls: ["./progress-bar.component.scss"],
})
export class ProgressBarComponent implements OnInit, OnChanges {
  public color: string;
  public progress: number;
  public checkPoints = [];
  public total: number;
  public estimate: number;
  @Input() barHeight: number;
  @Input() progressNumber: number;
  @Input() showIcon: boolean;
  @Input() isEstimate: boolean;
  @Input() status: string;
  @Input() progressbarHeaders: [];
  @Input() division: number = 0;
  Math: any;
  indicatorWidths: number[] = [];

  constructor() {
    this.Math = Math;
  }

  ngOnInit() {
    this.calculateProgress();
  }

  ngOnChanges() {
    this.calculateProgress();
    if (this.checkPoints.length !== this.progressNumber) {
      const tempcheckPoints = this.checkPoints;
      let difference = this.checkPoints.length - this.progressNumber;
      if(this.progressNumber >= 2) {
        tempcheckPoints.splice(difference,difference);
        this.checkPoints = tempcheckPoints;
      } else {
        this.checkPoints = tempcheckPoints.splice(difference);
      }   
    }
    this.addIndicators();
  }

  private calculateProgress(): void {
    if (!this.progress) {
      this.progress = 0;
    }

    if (!this.estimate) {
      this.estimate = 0;
    }

    if (this.total === 0) {
      this.total = this.progress;
      this.estimate = 0;
    } else if (!this.total) {
      this.total = 100;
    }
    let divisionPercent: number;
    if (this.division > 0) {
      divisionPercent = 100 / this.division;
    } else {
      divisionPercent = 100 / this.progressbarHeaders.length;
    }
    
    this.progress = this.progressNumber * divisionPercent;
    this.estimate = (this.progressNumber + 1) * divisionPercent;
    if (this.estimate > this.total) {
      this.estimate = 100;
    }
    if (this.progress > this.total) {
      this.progress = 100;
      this.total = 100;
      this.estimate = 100;
    }

    if (this.progress > 0) {
      this.checkPoints.push(this.progress);
    }
  }

  addIndicators() {
    const initial = this.estimate;
    let width = 0;
    if (this.progressbarHeaders !== undefined) {
      for (let index = 0; index < this.progressbarHeaders.length; index++) {
        width += initial;
        this.indicatorWidths.push(width);
      }
    }
  }
}
