import { Component } from '@angular/core';
import { MatDialog } from '@angular/material/dialog';
import { DialogService } from '../../services/dialog/dialog.service';
import { ToastService } from '../../services/toast/toast.service';

@Component({
  selector: 'bre-popups-page',
  templateUrl: './popups-page.component.html',
  styleUrls: ['./popups-page.component.scss']
})
export class PopupsPageComponent {

  dialog = {
    openSinglePageDialog: () => {
      this.dialogService.open(
        SinglePageDialogTem,
        { content: "Single Page Dialog" },
        (result) => {
          console.log(result);
        }
      );
    },
    openMultiPageDialog: () => {
      this.dialogService.open(
        MultiPageDialogTem,
        { selectedValue: null },
        (result) => {
          console.log(result);
        }
      );
    },
    openFullPageDialog: () => {
      this.matDialog.open(FullScreenDialogTem, {
        height: "100%",
        width: "100%",
      });
    },
  };


  toast = {
    showSuccessToast: () => {
      this.toastService.success("Sandbox Toast", "Click me", () => {
        alert("toast button clicked!");
      });
    },
    showErrorToast: () => {
      this.toastService.error("Sandbox Toast", "Click me", () => {
        alert("toast button clicked!");
      });
    },
    showToast: () => {
      this.toastService.success("Sandbox Toast");
    },
    showToastWithCarriageReturns: () => {
      this.toastService.error("Sandbox Toast\r\n\r\nCarriage Returns");
    },
    showToastWithCarriageReturnsButton: () => {
      this.toastService.success(
        "Sandbox Toast With Button\r\n\r\nCarriage Returns\r\nCarriage Returns\r\nCarriage Returns\r\n",
        "Click me",
        () => {
          alert("toast button clicked!");
        }
      );
    },
    showSuccessToastFromBottom: () => {
      this.toastService.success(
        "Sandbox Toast From Bottom\r\n\r\nCarriage Returns\r\nCarriage Returns\r\nCarriage Returns\r\n",
        "",
        () => { },
        "right",
        "30"
      );
    },
    showBanner: () => {
      this.toastService.banner(
        "A new Enhanced Vehicle Detection bundle is available for your market.  Check it out."
      );
    },
    showInfoToast: () => {
      this.toastService.informational("[Info Message]");
    },
    showInfoToastWithButton: () => {
      this.toastService.informational("[Info Message]", "Click me", () => {
        alert("toast button clicked!");
      });
    },
  };


  constructor(private dialogService: DialogService, private matDialog: MatDialog, private toastService: ToastService,
  ) { }

}
@Component({
  template: `
    <bre-dialog [showCloseButton]="true" headerText="this is header">
      <ng-template let-data let-close="close">
        {{ data.content }}
        <bre-button
          (onClick)="close(true)"
          label="Close"
          buttonClass="primary"
        ></bre-button>
        <bre-button
          (onClick)="close(false)"
          label="Cancel"
          buttonClass="secondary"
        ></bre-button>
      </ng-template>
    </bre-dialog>
  `,
})
export class SinglePageDialogTem { }

@Component({
  template: `
    <bre-dialog
      [showCloseButton]="true"
      [hideBackButton]="hideBackButton"
      (onPageChange)="updateHideBackButton($event)"
      [pagesCount]="3"
      footerText="this is footer"
    >
      <ng-template
        let-data
        let-close="close"
        let-currentPage="currentPage"
        let-next="nextPage"
        let-previous="previousPage"
      >
        <div style="width: 75vw; height: 50vh;" [ngSwitch]="currentPage">
          <div *ngSwitchCase="1">
            This is page 1.<br />
            <button (click)="next()">Go to next page</button>
          </div>
          <div *ngSwitchCase="2">
            This is page 2.<br />
            <input type="text" [(ngModel)]="data.selectedValue" /><br />
            <button (click)="previous()">Go to previous page</button>
            <button (click)="next()">Go to next page</button>
          </div>
          <div *ngSwitchCase="3">
            This is page 3.<br />
            Value entered is: {{ data.selectedValue }}<br />
            <button (click)="previous()">Go to previous page</button>
            <button (click)="close()">Close dialog</button>
          </div>
        </div>
      </ng-template>
    </bre-dialog>
  `,
})
export class MultiPageDialogTem {
  hideBackButton = false;
  updateHideBackButton(pageNumber) {
    this.hideBackButton = pageNumber === 3;
  }
}

@Component({
  template: `
    <bre-dialog-full-screen
      [isDialogFullScreen]="true"
      [showCloseButton]="true"
      [pagesCount]="2"
      [hideBackButton]="true"
      [headerText]="'Full Screen Dialog'"
      [progressbar_headers]="progressBarOptions"
      class="dialog-fullscreen"
      (onPageChange)="handlePageChange($event)"
    >
      <ng-template
        let-close="close"
        let-currentPage="currentPage"
        let-next="nextPage"
        let-previous="previousPage"
      >
        <div class="full-dialog">
          <div [hidden]="currentPage != 1">
            Page 1
            <div class="full-dialog__footer">
              <div class="full-dialog__footer-container">
                <div class="full-dialog__footer-right">
                  <bre-button
                    label="Next"
                    buttonClass="primary"
                    (onClick)="next($event)"
                  >
                  </bre-button>
                </div>
              </div>
            </div>
          </div>
          <div *ngIf="currentPage == 2">
            <div class="summary-wrapper">Page 2</div>
            <div class="full-dialog__footer">
              <div class="full-dialog__footer-container">
                <bre-button
                  label="Back"
                  buttonClass="secondary"
                  (onClick)="previous()"
                >
                </bre-button>
                <div class="full-dialog__footer-right">
                  <bre-button label="Confirm" buttonClass="primary">
                  </bre-button>
                </div>
              </div>
            </div>
          </div>
        </div>
      </ng-template>
    </bre-dialog-full-screen>
  `,
  styleUrls: ["./popups-page.component.scss"],
})
export class FullScreenDialogTem {
  currentPageNumber = 1;
  progressBarOptions = ["Page1 Heading", "Page1 Heading"];
  handlePageChange(pageNumber: number) {
    this.currentPageNumber = pageNumber;
  }
}