import { Component, Input, Output, ViewEncapsulation, EventEmitter } from "@angular/core";

@Component({
    selector: "bre-popover-menu-button",
    templateUrl: "popover-menu-button.component.html",
    styleUrls: ['./popover-menu-button.component.scss'],
    encapsulation: ViewEncapsulation.None,
})
export class PopoverMenuButtonComponent {
    @Input() menuItems: MenuItem[] = [];
    @Input() size: string = '';

    @Output() itemClicked: EventEmitter<MenuItem> = new EventEmitter();
    constructor() {}

    action(item: MenuItem) {
        item.action();
        this.itemClicked.emit(item);
    }
}

export interface MenuItem {
    label: string;
    action<T = unknown, R = unknown>(args?: T): R | void;
}