import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { MatMenuModule } from '@angular/material/menu';
import { IconButtonComponent } from '../icon-button/icon-button.component';

import { PopoverMenuButtonComponent, MenuItem } from './popover-menu-button.component';

describe('PopoverMenuButtonComponent', () => {
  let component: PopoverMenuButtonComponent;
  let fixture: ComponentFixture<PopoverMenuButtonComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [MatMenuModule],
      declarations: [ PopoverMenuButtonComponent, IconButtonComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(PopoverMenuButtonComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should emit an event when a popover menu item is clicked', () => {
    const testFunction = () => {};
    const item: MenuItem = { label: 'Test', action: testFunction };
    const spy1 = spyOn(item, 'action');
    const spy2 = spyOn(component.itemClicked, 'emit');

    component.action(item);
    expect(spy1).toHaveBeenCalled();
    expect(spy2).toHaveBeenCalledWith(item);
  });
});
