import { Component } from '@angular/core';
import { NavSubMenu } from '../nav-button/nav-button.component';
import { Router, ActivatedRoute } from "@angular/router";
import { TableSortDirection } from '../table/table.component';
import { ToastService } from '../../../lib/services/toast/toast.service';
@Component({
  selector: 'bre-navigation-tabs',
  templateUrl: './navigation-tabs.component.html',
  styleUrls: ['./navigation-tabs.component.scss']
})
export class NavigationTabsComponent  {

  constructor(private route: ActivatedRoute,
    private router: Router, private toastService: ToastService) {
          this.navigationBar._init();
     }
  tableNonPaginated = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
      { label: "Item 3", value: "4" },
      { label: "Item 4", value: "3" },
      { label: "Item 5", value: "4" },
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    itemCount: 5,
    /**
     * 
     * @param event 
     * Triggers on every oage change
     */
    pageChange: (event) => {
     console.log('page change event', event);
    },
    /**
     * 
     * @param event 
     * Triggers on every select change
     */
    selectedChange: (event) => {
      console.log('selection change event', event)
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      this.tableNonPaginated.items = [
        ...this.tableNonPaginated.sort(
          this.tableNonPaginated.items,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
    _init: () => {
      setTimeout(() => {
        this.tableNonPaginated.items = [
          { label: "Item 1", value: "1" },
          { label: "Item 2", value: "2" },
        ];
      }, 1000);
    },
  };
  navigationBar = {
    items: [
      { label: "App", url: "/sandbox/navigation-tabs", isActive: false },
      { label: "Foo", url: "/sandbox/nav/1", isActive: false },
      { label: "Bar", url: "/sandbox/nav/1/bar", isActive: false },
    ],
    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      this.tableNonPaginated.items = [
        ...this.tableNonPaginated.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
    _init: () => {
      this.route?.url?.subscribe(() => {
        this.navigationBar.items.forEach((x) => {
          x.isActive = x.url === this.router.url.split("?")[0];
        });
      });
    },
  };

  navSubmenus: NavSubMenu[] = [
    { label: "Submenu 1", url: "/sandbox/submenu/1" },
    { label: "Submenu 2", url: "/sandbox/submenu/2" },
    { label: "Disabled Submenu", url: "/sandbox/submenu/3", disabled: true },
  ];

  accordionMenu = {
    items: [
      {
        value: "1",
        label: "Item 1",
        children: [
          { label: "Item 1a", value: "1a" },
          {
            label: "Item 1b",
            value: "1b",
            children: [
              { label: "Item 1ba", value: "1ba" },
              {
                label: "Item 1bb",
                value: "1bb",
                children: [{ label: "Item 1bba", value: "1bba" }],
              },
            ],
          },
          { label: "Item 1c", value: "1b" },
        ],
      },
      {
        value: "2",
        label: "Item 2",
      },
    ],
    onClick: (event) => {
      this.toastService.success(`Item ${event} clicked!`);
    },
  };

  tabs = {
    changeTab: (event) => console.log("tab changed", event),
    selectedIndex: 2,
  };

  progress: number = 0;
  progressbar_headers: string[] = ['Select deployment type', 'Select device(s)', 'Select hierarchy level  and store(s)', 'Confirm and deploy']

}
