import { Component, Input, OnInit } from '@angular/core';
import { Router, NavigationEnd, ActivatedRoute } from '@angular/router';
import { NavSubMenu } from '../nav-button/nav-button.component';

@Component({
  selector: 'bre-navigation-panel',
  templateUrl: './navigation-panel.component.html',
  styleUrls: ['./navigation-panel.component.scss']
})
export class NavigationPanelComponent implements OnInit {

  isActive: boolean = false;
  @Input() isDisabled: boolean = false;
  @Input() iconSrc: string;
  @Input() selectedIconSrc: string;
  @Input() label: string;
  @Input() labelSecondLine: string;
  @Input() url: string;
  @Input() subMenus: NavSubMenu[]
  @Input() hideImage: boolean = false;

  constructor(private router: Router) { }

  ngOnInit(): void {
    const activeUrl = this.router.url;
    this.isActive = (`/${activeUrl}` === this.url);
    this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        // check url after any redirects
        const activeUrl = event.urlAfterRedirects;
        this.isActive = (`${activeUrl}` === this.url);
      }
    });    
  }

  isSubmenuActive(submenu: NavSubMenu): boolean {
    if(this.router.url === submenu.url) {
      this.isActive = (this.router.url === submenu.url)
      return (this.router.url === submenu.url);
    }
  
  }
}
