import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { NavigationBarComponent } from './navigation-bar.component';
import { RouterTestingModule } from '@angular/router/testing';

describe('NavigationBarComponent', () => {
  let component: NavigationBarComponent;
  let fixture: ComponentFixture<NavigationBarComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [NavigationBarComponent],
      imports: [RouterTestingModule]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(NavigationBarComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display one line per item', () => {
    component.items = [
      { label: '123', url: '/foo', isActive: false },
      { label: 'xyz', url: '/bar', isActive: true }
    ];
    fixture.detectChanges();

    const links = fixture.nativeElement.querySelectorAll('a');
    expect(links.length).toBe(2);
    expect(links[0].href).toBe('https://github.com/foo');
    expect(links[0].innerHTML).toContain('123');    
    expect(links[0].parentElement.classList.contains('active')).toBe(false);
    expect(links[1].href).toBe('https://github.com/bar');
    expect(links[1].innerHTML).toContain('xyz');
    expect(links[1].parentElement.classList.contains('active')).toBe(true);
  });
});
