import { Component, OnInit, Input } from '@angular/core';
import { Router, NavigationEnd, ActivatedRoute } from '@angular/router';

@Component({
  selector: 'bre-nav-button',
  templateUrl: './nav-button.component.html',
  styleUrls: ['./nav-button.component.scss']
})
export class NavButtonComponent implements OnInit {
  isActive: boolean = false;
  @Input() isDisabled: boolean = false;
  @Input() iconSrc: string;
  @Input() selectedIconSrc: string;
  @Input() label: string;
  @Input() url: string;
  @Input() subMenus: NavSubMenu[]

  constructor(private router: Router) { }

  ngOnInit(): void {
   const activeUrl = this.router.url.split('/')[1];
   this.isActive = (`/${activeUrl}` === this.url);
    this.router.events.subscribe(event => {
      if (event instanceof NavigationEnd) {
        // check url after any redirects
       const activeUrl = event.urlAfterRedirects.split('/')[1];
        this.isActive = (`/${activeUrl}` === this.url);
      }
    });
  }

  isSubmenuActive(submenu: NavSubMenu): boolean {
    return (this.router.url === submenu.url);
  }
}

export interface NavSubMenu {
  label: string,
  url: string,
  disabled?: boolean
}