import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { RouterTestingModule } from '@angular/router/testing';

import { NavButtonComponent } from './nav-button.component';


describe('NavButtonComponent', () => {
  let component: NavButtonComponent;
  let fixture: ComponentFixture<NavButtonComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [RouterTestingModule],
      declarations: [NavButtonComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(NavButtonComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should set a label for the nav button based upon input', () => {
    var compiled = fixture.nativeElement;
    var labelElement = compiled.querySelector('.nav-button-text');
    expect(labelElement).toBeTruthy();
    expect(labelElement.textContent).toBe('');

    component.label = 'Test';
    fixture.detectChanges();

    compiled = fixture.nativeElement;
    labelElement = compiled.querySelector('.nav-button-text');
    expect(labelElement).toBeTruthy();
    expect(labelElement.textContent).toBe('Test');
  });

  it('should set an icon for the nav button based upon input', () => {
    var compiled = fixture.nativeElement;
    var iconElement = compiled.querySelector('.nav-button-icon img');
    expect(iconElement).toBeTruthy();
    expect(iconElement.src).toBe('https://github.com/null'); // default src

    component.iconSrc = './example.svg';
    fixture.detectChanges();

    compiled = fixture.nativeElement;
    iconElement = compiled.querySelector('.nav-button-icon img');
    expect(iconElement).toBeTruthy();
    expect(iconElement.src).toBe('https://github.com/example.svg');
  });

  it('should set an url for the nav button\'s link based upon input', () => {
    var compiled = fixture.nativeElement;
    var linkElement = compiled.querySelector('a');
    expect(linkElement).toBeTruthy();
    expect(linkElement.href).toBe('https://github.com/');

    component.url = '/test';
    fixture.detectChanges();

    compiled = fixture.nativeElement;
    linkElement = compiled.querySelector('a');
    expect(linkElement).toBeTruthy();
    expect(linkElement.href).toBe('https://github.com/test');
  });

  it('should display the selected version of the icon for the nav button when the nav button is active', () => {
    component.iconSrc = './example.svg';
    component.selectedIconSrc = './example2.svg';
    component.isActive = false;
    fixture.detectChanges();

    var compiled = fixture.nativeElement;
    var iconElement = compiled.querySelector('.nav-button-icon img');
    expect(iconElement).toBeTruthy();
    expect(iconElement.src).toBe('https://github.com/example.svg');

    component.isActive = true;
    fixture.detectChanges();

    compiled = fixture.nativeElement;
    iconElement = compiled.querySelector('.nav-button-icon img');
    expect(iconElement).toBeTruthy();
    expect(iconElement.src).toBe('https://github.com/example2.svg');
  });

  it('should not display submenu if not defined', () => {
    expect(fixture.nativeElement.querySelector('.nav-button .submenu')).toBeFalsy();
  });

  it('should display submenu if defined', () => {
    component.url = '/test';
    component.subMenus = [
      { label: 'Foo', url: '/test/1' },
      { label: 'Bar', url: '/test/2' }
    ];
    fixture.detectChanges();

    const submenuEl = fixture.nativeElement.querySelectorAll('.nav-button .submenu a');
    expect(submenuEl.length).toBe(2);
    expect(submenuEl[0].innerHTML).toContain('Foo');
    expect(submenuEl[0].href).toBe('https://github.com/test/1');
    expect(submenuEl[1].innerHTML).toContain('Bar');
    expect(submenuEl[1].href).toBe('https://github.com/test/2');
  });
});
