import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ReactiveFormsModule, FormGroup, FormControl } from '@angular/forms';
import { ButtonModule } from 'primeng/button';
import { MultiSelectModule } from 'primeng/multiselect';
import { MultiSelectComponent } from './multi-select.component';
import { InputErrorMessageComponent } from '../input-error-message/input-error-message.component';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { MatMenuModule } from '@angular/material/menu';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { TooltipDirective } from '../tooltip/tooltip.directive';
import { ErrorIconComponent } from '../error-icon/error-icon.component';

describe('MultiSelectComponent', () => {
  let component: MultiSelectComponent;
  let fixture: ComponentFixture<MultiSelectComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ReactiveFormsModule, ButtonModule, MultiSelectModule, MatMenuModule],
      declarations: [MultiSelectComponent, InputErrorMessageComponent, PopoverMenuButtonComponent, IconButtonComponent, ControlLabelComponent, TooltipDirective, ErrorIconComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(MultiSelectComponent);
    component = fixture.componentInstance;
    component.items = [{ label: 'Item 1', value: 1 }, { label: 'Item 2', value: 2 }];
    component.value = [2];
    component.ngOnInit();
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display a label if one has been declared', () => {
    component.label = "Test";
    component.ngOnInit();
    fixture.detectChanges();
    expect(component.componentUUID).toContain('test');
  });

  it('should display selected items labels correctly', () => {
    expect(fixture.nativeElement.querySelector('.ui-multiselected-item-token .item-label').innerHTML).toContain('Item 2');
  });

  it('should correctly update formGroup when removing item', () => {
    expect(component.parentForm.get('value').value).toStrictEqual([2]);
    expect(component.value).toStrictEqual([2]);

    fixture.nativeElement.querySelector('.ui-multiselected-item-token .pi-times').click();
    fixture.detectChanges();

    expect(component.parentForm.get('value').value).toStrictEqual([]);
    expect(component.value).toStrictEqual([]);
  });

  it('should mark the form field as pristine if reset to its initial value and dirty if set to another value', () => {
    component.initialValue = ['1'];
    component.controlName = 'testControl';
    component.parentForm = new FormGroup({ 'testControl': new FormControl([''])});
    const pristineSpy = spyOn(component.parentForm.get(component.controlName), 'markAsPristine');
    component.changeSelections({ value: ['1'] });

    expect(pristineSpy).toHaveBeenCalled();

    const dirtySpy = spyOn(component.parentForm.get(component.controlName), 'markAsDirty');
    component.changeSelections({ value: ['1', '2'] });

    expect(dirtySpy).toHaveBeenCalled();
  });
});
