import { Component, Input, OnInit } from "@angular/core";
import { AnimationOptions } from "ngx-lottie";
import * as animData from "./animations/McFries.json";

@Component({
  selector: "bre-loader",
  templateUrl: "./loader.component.html",
  styleUrls: ["./loader.component.scss"],
})
export class LoaderComponent implements OnInit {
  @Input() isLoading: boolean;
  @Input() height: string;
  @Input() width: string;
  @Input() loaderTextChange: boolean = false;
  @Input() loaderText: string;
  @Input() secondaryText: boolean = false;
  @Input() secondaryTextValue: string;
  options: AnimationOptions = {
    animationData: (animData as any).default,
    renderer: "svg",
  };

  ngOnInit() {}
}
