import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { LottieModule } from 'ngx-lottie';
import { LoaderComponent } from './loader.component';

describe('LoaderComponent', () => {
  let component: LoaderComponent;
  let fixture: ComponentFixture<LoaderComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ LoaderComponent ],
      imports: [LottieModule]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(LoaderComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should not render if isLoading is set to false', () => {
    const isLoading = false;
    component.isLoading = isLoading;
    const div = fixture.nativeElement.querySelector('div');
    expect(div).toBe(null);
    expect(component.isLoading).toBe(false);
  });

  it('should render if isLoading is set to true', () => {
    const isLoading = true;
    component.isLoading = isLoading;
    const div = fixture.nativeElement.querySelector('div');
    expect(div).toBeDefined();
    expect(component.isLoading).toBe(true);
  });

});
