import { Component, Input, Output, EventEmitter } from '@angular/core';
import { v4 as uuid } from 'uuid';

@Component({
  selector: 'bre-icon-button',
  templateUrl: './icon-button.component.html',
  styleUrls: ['./icon-button.component.scss']
})
export class IconButtonComponent {
  @Input() icon: string;
  @Input() type: string;
  @Input() disabled: boolean;
  @Input() loading: boolean;
  @Output() onClick: EventEmitter<MouseEvent> = new EventEmitter<MouseEvent>();

  componentUUID: string;

  ngOnInit(): void {
    this.componentUUID = `${this.icon}_button_${uuid()}`;
  }

  handleClick(event: MouseEvent) {
    this.onClick?.emit(event);
  }
}
