import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { IconButtonComponent } from './icon-button.component';
import { EventEmitter } from 'events';

describe('IconButtonComponent', () => {
  let component: IconButtonComponent;
  let fixture: ComponentFixture<IconButtonComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [IconButtonComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(IconButtonComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('it should show correct icon and type', () => {
    component.type = 'xyz';
    component.icon = 'foobar';
    fixture.detectChanges();

    expect(fixture.nativeElement.querySelector('.icon-button.xyz')).toBeDefined();
    expect(fixture.nativeElement.querySelector('.icon-button .pi.pi-foobar')).toBeDefined();
  });

  it('it should handle click', () => {
    const click = jest.fn();
    component.onClick.emit = click;
    fixture.detectChanges();

    fixture.nativeElement.querySelector('button').click();

    expect(click).toHaveBeenCalled();
  });

  it('it should ignore click if disabled', () => {
    const click = jest.fn();
    component.onClick.emit = click;
    component.disabled = true;
    fixture.detectChanges();

    fixture.nativeElement.querySelector('button').click();

    expect(click).not.toHaveBeenCalled();
  });

  it('should show spinner if loading', () => {
    component.loading = true;
    fixture.detectChanges();

    expect(fixture.nativeElement.querySelector('.icon-button .pi.pi-spin.pi-spinner')).toBeDefined();
  });

  it('should emit a click event if one is declared', () => {
    const spy = spyOn(component.onClick, 'emit');
    const event: MouseEvent = new MouseEvent('test');
    component.handleClick(event);
    expect(spy).toHaveBeenCalledWith(event);
  });
});
