import { TestBed, ComponentFixture } from '@angular/core/testing';
import { GridRowDirective } from './grid-row.directive';
import { Component } from '@angular/core';

@Component({
  selector: 'bre--mock',
  template: '<div breGridRow>Mock Component</div>'
})
class MockComponent {}

describe('GridRowDirective', () => {
  let directive: GridRowDirective;
  let component: MockComponent;
  let fixture: ComponentFixture<MockComponent>;

  beforeEach(() => {
    TestBed.configureTestingModule({
      declarations: [
        MockComponent,
        GridRowDirective
      ]
    }).compileComponents();

    fixture = TestBed.createComponent(MockComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
    directive = new GridRowDirective();
  });

  it('should create an instance', () => {
    const directive = new GridRowDirective();
    expect(directive).toBeTruthy();
  });

  it('should add the grid row class to the element it is applied to', () => {
    let compiled = fixture.nativeElement;
  
    let gridElement = compiled.querySelector('div');
    expect(gridElement.classList).toContain(directive.gridRowClass);
  });
});
