import { Directive, HostBinding, Input, OnInit } from '@angular/core';

@Directive({
  selector: '[breGridColumn]'
})
export class GridColumnDirective implements OnInit {
  @Input() columnSize: number;

  @HostBinding('class')
  columnClass:string = 'p-col';

  @Input()
  @HostBinding('class.p-col-fixed')
  fixedWidth:boolean = false;

  constructor() {
  }

  ngOnInit(): void {
    // column size assumes a 12 grid, value must be between 1 and 12 to be valid
    if(this.columnSize && this.columnSize > 0 && this.columnSize <= 12) {
      this.columnClass = 'p-col-' + this.columnSize.toString();
    }
  }
}