import { TestBed, ComponentFixture } from '@angular/core/testing';
import { GridColumnDirective } from './grid-column.directive';
import { Component } from '@angular/core';

@Component({
  selector: 'bre-base-mock',
  template: '<div breGridColumn>Mock Component</div>'
})
class BaseMockComponent {}

@Component({
  selector: 'bre-fixed-width-mock',
  template: '<div breGridColumn fixedWidth="true">Mock Component</div>'
})
class FixedWidthMockComponent {}

describe('GridColumnDirective', () => {
  let directive: GridColumnDirective;
  let baseComponent: BaseMockComponent;
  let baseFixture: ComponentFixture<BaseMockComponent>;
  let fixedComponent: FixedWidthMockComponent;
  let fixedFixture: ComponentFixture<FixedWidthMockComponent>;

  beforeEach(() => {
    TestBed.configureTestingModule({
      declarations: [
        BaseMockComponent,
        FixedWidthMockComponent,
        GridColumnDirective
      ]
    }).compileComponents();
    baseFixture = TestBed.createComponent(BaseMockComponent);
    baseComponent = baseFixture.componentInstance;
    baseFixture.detectChanges();

    fixedFixture = TestBed.createComponent(FixedWidthMockComponent);
    fixedComponent = fixedFixture.componentInstance;
    fixedFixture.detectChanges();
    directive = new GridColumnDirective();
  });

  it('should create an instance', () => {
    expect(directive).toBeTruthy();
  });

  it('should set the column class based upon size input', () => {
    directive.columnSize = 10;
    directive.ngOnInit();
    expect(directive.columnClass).toBe(`p-col-${directive.columnSize}`);
  })

  it('should add the grid column class to the element it is applied to', () => {
    let compiled = baseFixture.nativeElement;
  
    let columnElement = compiled.querySelector('div');
    expect(columnElement.classList).toContain(directive.columnClass);
  });

  it('should add the fixed width grid column class to the element it is applied to when that input is present', () => {
    let compiled = baseFixture.nativeElement;
  
    let columnElement = compiled.querySelector('div');
    expect(columnElement.classList).not.toContain('p-col-fixed');

    compiled = fixedFixture.nativeElement;
  
    columnElement = compiled.querySelector('div');
    expect(columnElement.classList).toContain('p-col-fixed');
  });
});
