import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { FullscreenDialogComponent } from './fullscreen-dialog.component';
import { MatDialogRef, MAT_DIALOG_DATA, MatDialog } from '@angular/material/dialog';
import { ProgressBarComponent } from '../progress-bar/progress-bar.component';
import { FullscreenDialogService } from '../../services/fullscreen-dialog.service';

const mockMatDialogRef = { close: jest.fn() };

describe('FullscreenDialogComponent', () => {
  let component: FullscreenDialogComponent;
  let fixture: ComponentFixture<FullscreenDialogComponent>;
  const mockSubscribe = jest.fn();
  const mockOpen = jest.fn((content, config) => ({ afterClosed: () => ({ subscribe: mockSubscribe }) }));
  class MockMatDialog {
    open(content, config) {
      return mockOpen(content, config);
    }
  }
  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ FullscreenDialogComponent,ProgressBarComponent ],
      imports: [],
      providers: [
        { provide: MAT_DIALOG_DATA, useValue: [] },
        { provide: MatDialogRef, useValue: mockMatDialogRef },
        { provide: MatDialog, useValue: new MockMatDialog() },
        FullscreenDialogService
      ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(FullscreenDialogComponent);
    component = fixture.componentInstance;
    component.progressbar_headers = ['1', '2'];
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });
});
