import { Component, OnInit } from '@angular/core';
import {
  DialogService,
  ToastService,
  FilterType,
  FiltersChangeEvent,
  NavSubMenu,
  DefaultKeyFilters,
  QuickJumpViewLoadDataEvent,
  TableEditOption,
} from "../../../../../core/src/public-api";

import { PageSizes, TableSortDirection } from '../table/table.component';

@Component({
  selector: 'bre-filters-page',
  templateUrl: './filters-page.component.html',
  styleUrls: ['./filters-page.component.scss']
})
export class FiltersPageComponent implements OnInit {

  paginatedTable = {
    items: [],
    itemCount: 20,
    page: undefined,
    pageSize: undefined,
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    pageChange: (event) => {
      // console.log('page change event', event);
      this.paginatedTable.items = [
        ...this.paginatedTable.sort(
          event.data,
          event.sortBy,
          event.sortDirection
        ),
      ];
    },
    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log(sortItem.sortDirection);
      this.paginatedTable.items = [
        ...this.paginatedTable.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateItemCount: (itemCount) => {
      this.paginatedTable.itemCount = parseInt(itemCount, 10);
    },
    _init: () => {
      this.paginatedTable.page = 2;
      this.paginatedTable.pageSize = PageSizes.TwentyFive;
      setTimeout(() => {
        this.paginatedTable.items = [
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          { label: "Item 6", value: "6" },
          { label: "Item 1", value: "1" },
          { label: "Item 3", value: "3" },
          { label: "Item 2", value: "2" },
          { label: "Item 4", value: "3" },
          { label: "Item 5", value: "5" },
          {
            label: "Item 6",
            value:
              "test test test test test test test test test test test test test test test test test test test test test test test test ",
          },
        ];
        this.paginatedTable.itemCount = 179;
      }, 1000);
    },
  };

  paginatedTableWithFilters = {
    items: [
      {
        label: "Item 1",
        value: "1",
        name: "test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 test1 ",
        date: "2022-12-01 00:56:20 ",
      },
      {
        label: "Item 3",
        value: "3",
        name: "test2",
        date: "1999-02-02 22:59:55 ",
      },
      {
        label: "Item 2",
        value: "2",
        name: "test3",
        date: "2020-10-08 22:59:55 ",
      },
      {
        label: "Item 4",
        value: "3",
        name: "test4",
        date: "1987-10-06 22:59:55 ",
      },
      {
        label: "Item 5",
        value: "5",
        name: "test5",
        date: "2022-02-08 22:59:55 ",
      },
      {
        label: "Item 6",
        value: "6",
        name: "test6",
        date: "2022-02-08 21:59:55 ",
      },
    ],
    itemCount: 6,
    page: 1,
    pageSize: 25,
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    pageChange: (event) => {
      // console.log('page change event', event);
      this.paginatedTableWithFilters.items = [
        ...this.paginatedTableWithFilters.sort(
          event.data,
          event.sortBy,
          event.sortDirection
        ),
      ];
    },
    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log(sortItem.sortDirection);
      this.paginatedTableWithFilters.items = [
        ...this.paginatedTableWithFilters.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },

    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateItemCount: (itemCount) => {
      this.paginatedTableWithFilters.itemCount = parseInt(itemCount, 10);
    },
    confirmInputValue: (event) => {
      //  console.log('input entered and apply button clicked', event);
    },
  };

  
  tableNonPaginated = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
      { label: "Item 3", value: "4" },
      { label: "Item 4", value: "3" },
      { label: "Item 5", value: "4" },
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    itemCount: 5,
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log(sortItem.sortDirection);
      this.tableNonPaginated.items = [
        ...this.tableNonPaginated.sort(
          this.tableNonPaginated.items,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
    _init: () => {
      setTimeout(() => {
        this.tableNonPaginated.items = [
          { label: "Item 1", value: "1" },
          { label: "Item 2", value: "2" },
        ];
      }, 1000);
    },
  };

  tableNonPaginatedWithFilters = {
    selectedColumn: "typeVal",
    filterLabel: "Filter by Value",
    itemCount: 5,
    items: [
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        hiddenValue0: "hidden 0 0",
        hiddenValue1: "hidden 1 0",
        hiddenValue2: "hidden 2 0",
        typeVal: "check1",
      },
      {
        label: "Items 2",
        value: "2",
        checkbox: "old",
        date: "2020-10-08 22:59:55 ",
        hiddenValue0: null,
        hiddenValue1: null,
        hiddenValue2: "",
        typeVal: "check1",
      },
      {
        label: "Items 3",
        value: "4",
        checkbox: "new",
        date: "1987-10-06 22:59:55 ",
        hiddenValue0: null,
        hiddenValue1: null,
        hiddenValue2: "one hidden value",
        typeVal: "check2",
      },
      {
        label: "Items 4",
        value: "3",
        checkbox: "old",
        date: "2019-03-08 22:59:55 ",
        hiddenValue0: "hidden 0",
        hiddenValue1: "hidden 1",
        hiddenValue2: "hidden 2",
        typeVal: "check1",
      },
      {
        label: "Item 5",
        value: "4",
        checkbox: "new",
        date: "2020-05-19 22:59:55 ",
        hiddenValue0: null,
        hiddenValue1: null,
        hiddenValue2: null,
        typeVal: "check2",
      },
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    checkboxOptions: [
      { label: "fresh", value: "fresh" },
      { label: "old", value: "old" },
      { label: "new", value: "new" },
    ],
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateConfirmed: (event) => {
      console.log("row update confirmed", event);
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log('sort item!:', sortItem);
      this.tableNonPaginatedWithFilters.items = [
        ...this.tableNonPaginatedWithFilters.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },
  };

  editableFilterTable = {
    itemCount: 5,
    items: [
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        menuItems: [
          {
            // this label is important in order to trigger edit functionality in the core table components
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 2",
        value: "2",
        checkbox: "old",
        date: "2020-10-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 3",
        value: "4",
        checkbox: "new",
        date: "1987-10-06 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 4",
        value: "3",
        checkbox: "old",
        date: "2019-03-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 5",
        value: "4",
        checkbox: "new",
        date: "2020-05-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: undefined,
        value: "5",
        checkbox: "new",
        date: "2020-06-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
    ],
    sortBy: "value",
    sortDirection: TableSortDirection.asc,
    checkboxOptions: [
      { label: "fresh", value: "fresh" },
      { label: "old", value: "old" },
      { label: "new", value: "new" },
    ],
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateConfirmed: (event) => {
      console.log("row update confirmed", event);
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log('sort item!:', sortItem);
      this.editableFilterTable.items = [
        ...this.editableFilterTable.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },

    getAttributeValueOptions(attributeValue): any[] {
      return [
        {
          // this label is important in order to trigger edit functionality in the core table components
          label: TableEditOption.update,
          action: () => {},
        },
        {
          label: TableEditOption.delete,
          action: () => {
            this.delete(attributeValue);
          },
        },
      ];
    },
  };

  prefilledEditableFilterTable = {
    itemCount: 5,
    items: [
      {
        label: "Item 1",
        value: "1",
        checkbox: "new",
        date: "1987-10-08 22:59:55 ",
        menuItems: [
          {
            // this label is important in order to trigger edit functionality in the core table components
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 2",
        value: "2",
        checkbox: "old",
        date: "1987-10-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 3",
        value: "4",
        checkbox: "new",
        date: "1987-10-06 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 4",
        value: "3",
        checkbox: "old",
        date: "2019-03-08 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: "Item 5",
        value: "4",
        checkbox: "new",
        date: "2020-05-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
      {
        label: undefined,
        value: "5",
        checkbox: "new",
        date: "2020-06-19 22:59:55 ",
        menuItems: [
          {
            label: TableEditOption.update,
            action: () => {},
          },
          {
            label: TableEditOption.delete,
            action: () => {
              console.log("delete");
            },
          },
        ],
      },
    ],
    sortBy: "value",
    initialColumnFilters: [
      {
        columnName: "value",
        columnFilter: {
          checkboxFilters: [{ label: "1", value: "1" }],
        },
      },
      {
        columnName: "date",
        columnFilter: {
          checkboxFilters: [
            { label: "1987-10-08 22:59:55 ", value: "1987-10-08 22:59:55 " },
          ],
        },
      },
    ],
    sortDirection: TableSortDirection.asc,
    checkboxOptions: [
      { label: "fresh", value: "fresh" },
      { label: "old", value: "old" },
      { label: "new", value: "new" },
    ],
    pageChange: (event) => {
      // console.log('page change event', event);
    },
    selectedChange: (event) => {
      // console.log('selection change event', event)
    },
    updateConfirmed: (event) => {
      console.log("row update confirmed", event);
    },

    sort: (arr, sortColumn, ascOrDsc) => {
      arr.sort((a, b) => {
        if (sortColumn === "date") {
          a = new Date(a[sortColumn]);
          b = new Date(b[sortColumn]);
          if (ascOrDsc === "asc") return a - b;
          else {
            return b - a;
          }
        }
        if (a[sortColumn] > b[sortColumn] && ascOrDsc === "asc") {
          return 1;
        } else {
          return -1;
        }
      });
      return arr;
    },
    sortColumn: (sortItem) => {
      // console.log('sort item!:', sortItem);
      this.editableFilterTable.items = [
        ...this.editableFilterTable.sort(
          sortItem.data,
          sortItem.sortBy,
          sortItem.sortDirection
        ),
      ];
    },

    getAttributeValueOptions(attributeValue): any[] {
      return [
        {
          // this label is important in order to trigger edit functionality in the core table components
          label: TableEditOption.update,
          action: () => {},
        },
        {
          label: TableEditOption.delete,
          action: () => {
            this.delete(attributeValue);
          },
        },
      ];
    },
  };

  quickJump = {
    data: [],
    total: 20,
    loadMore: (event: QuickJumpViewLoadDataEvent) => {
      this.quickJump.loading = true;
      setTimeout(() => {
        for (let i = event.start; i < event.end; i++) {
          this.quickJump.data.push({ label: `Item ${i}` });
        }
        this.quickJump.loading = false;
      }, 250);
    },
    loading: true,
  };

  constructor() { }

  ngOnInit(): void {
    this.paginatedTable._init();
  }

}
