export interface Filter {
  name: string;
  type: FilterType;
  placeholder: string;
  isAdvanced: boolean;
  value?: string;
  options?: FilterOption[];
  loadOptions?: (searchTerm: string) => void;
  validRoles?: any[];
  intialValue?:string;
}

export enum FilterType {
  autocomplete = 'auto-complete',
  calendar = 'calendar',
  dropdown = 'dropdown',
  multiselect = 'multi-select',
  input = 'input'
}

export interface FilterOption {
  label: string;
  value: string | number;
}

export interface FiltersChangeEvent {
  filters: any;
}

export interface FilterChangeEvent {
  value: any;
}
