import {
  Component,
  Input,
  Output,
  EventEmitter,
  OnChanges,
  ChangeDetectorRef,
} from "@angular/core";
import { FormControl, FormGroup } from "@angular/forms";
import {
  FiltersChangeEvent,
  FilterChangeEvent,
  Filter,
  FilterType,
} from "./filter.interface";

@Component({
  selector: "bre-filter-group",
  templateUrl: "./filter-group.component.html",
  styleUrls: ["./filter-group.component.scss"],
})
export class FilterGroupComponent implements OnChanges {
  @Input() filters: Filter[];
  @Input() selectedFilters: object;
  @Input() clearAllFields: boolean;
  @Input() shouldShowAdvancedFilter: boolean;
  @Input() switchDropdown;
  @Input() addBorderRadius: boolean = false;
  @Output() filterDidChange: EventEmitter<FiltersChangeEvent> =
    new EventEmitter();
  @Output() searchButtonClicked: EventEmitter<boolean> = new EventEmitter();
  @Output() dropdownChangeEvent: EventEmitter<boolean> = new EventEmitter();
  @Output() backToInitialState: EventEmitter<boolean> = new EventEmitter();
  @Input() hideDropDownSearch: boolean = false;
  @Input() canClearItems: boolean = false;
  searchClicked: boolean = false;
  dropdownChanged: boolean = false;
  showFullList: boolean = false;

  public expandAdvancedFilters = false;

  filterForm: any;

  constructor(private cdRef: ChangeDetectorRef) {}

  ngOnChanges() {
    const group = {};
    if (this.filters && !this.filterForm) {
      this.filters.forEach((control) => {
        group[control.name] = new FormControl(control.value || "");
      });
      this.filterForm = new FormGroup(group);
    }
    if (this.clearAllFields && Object.keys(this.selectedFilters).length !== 0) {
      this.handleClearAllFilters();
      this.clearAllFields = false;
      this.cdRef.detectChanges();
    }
  }

  ngAfterContentChecked() {
    this.cdRef.detectChanges();
  }

  launchAdvancedFilter(): void {
    this.expandAdvancedFilters = !this.expandAdvancedFilters;
  }

  calendarValueChange(value, name: string) {
    this.filterChange({ value }, name);
  }

  filterChange(event: FilterChangeEvent, name: string): void {
    this.selectedFilters = {
      ...this.selectedFilters,
      ...{ [name]: event.value },
    };
    for (let key in this.selectedFilters) {
      if (
        !this.selectedFilters[key] ||
        this.selectedFilters[key].length === 0
      ) {
        delete this.selectedFilters[key];
      }
    }
    if (this.switchDropdown === true) {
      if (name === "status") {
        this.filterDidChange.emit({
          filters: this.selectedFilters,
        });
        //this condition will return false if both search input and status is empty and list will be reset to initial
        if (
          this.filterForm.value.productCodeAndName === "" &&
          this.filterForm.value.status.length === 0
        ) {
          this.backToInitialState.emit(false);
        } else {
          this.backToInitialState.emit(true);
        }
      }
      //calling this function which will return true if the input is empty and dropdown has "Contains",
      // otherwise it returns false and list doesn't refresh
      if (name === "productCodeAndName") {
        this.showFullListfn(event.value);
      }
      if (
        this.selectedFilters["dropdown"] === "Contains" &&
        this.showFullList
      ) {
        this.dropdownChanged = true;
      } else {
        this.dropdownChanged = false;
      }
      this.dropdownChangeEvent.emit(this.dropdownChanged);
    } else {
      this.filterDidChange.emit({
        filters: this.selectedFilters,
      });
    }
  }
  //function which will return true/false depeding upon input value

  showFullListfn(event) {
    // if (event === "") {
    //   this.showFullList = true;
    //   this.filterDidChange.emit({
    //     filters: this.selectedFilters
    //   });
    // }
    // else {
    //   this.showFullList = false;
    // }
    if (event === "") {
      this.backToInitialState.emit(false); //this will emit flag to reset to initial state if searched string is empty
    }
  }

  unselectItem($event: MouseEvent, filterName: string, item: any): void {
    $event.stopPropagation();
    const clickedItemIndex = this.selectedFilters[filterName].indexOf(item);
    if (clickedItemIndex > -1) {
      this.selectedFilters[filterName].splice(clickedItemIndex, 1);
      this.filterDidChange.emit({
        filters: this.selectedFilters,
      });
    }
  }

  getItemLabel(filter, itemValue) {
    return (
      filter?.options?.find((x) => x.value === itemValue)?.label || itemValue
    );
  }

  handleClose($event): void {
    this.expandAdvancedFilters = false;
  }

  handleClearAllFilters(): void {
    this.filterDidChange.emit({
      filters: this.filters.reduce((result, key) => {
        if (
          key.type === FilterType.autocomplete ||
          key.type === FilterType.multiselect
        ) {
          result[key.name] = [];
        } else {
          result[key.name] = null;
          this.filterForm.patchValue({ [key.name]: null });
        }
        return result;
      }, {}),
    });
  }

  //function called when search button clicked

  searchClickedfn(): void {
    //condition given to load list only when string is empty
    if (this.filterForm.value.productCodeAndName != "") {
      this.selectedFilters["productCodeAndName"] =
        this.filterForm.value.productCodeAndName;
      this.searchClicked = true;
      this.searchButtonClicked.emit(this.searchClicked);

      this.filterDidChange.emit({
        filters: this.selectedFilters,
      });
    }
  }
}
