import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { AdvancedFilterComponent } from './advanced-filter.component';
import { ButtonComponent } from '../../button/button.component';
import { ButtonModule } from 'primeng/button';
import { ProgressSpinnerModule } from 'primeng/progressspinner';

describe('AdvancedFilterComponent', () => {
  let component: AdvancedFilterComponent;
  let fixture: ComponentFixture<AdvancedFilterComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ButtonModule, ProgressSpinnerModule],
      declarations: [AdvancedFilterComponent, ButtonComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(AdvancedFilterComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should have a title of Advanced Filters', () => {
    const compiled = fixture.nativeElement;
    const title = compiled.querySelector('.advanced-filters > .head > h2').innerHTML;
    expect(title).toEqual('Advanced Filters')
  });

  it('should emit an event on clear', () => {
    const spy = spyOn(component.clearAllFilters, 'emit');
    component.clear()
    expect(spy).toHaveBeenCalled();
  });

  it('should emit an event on close', () => {
    const spy = spyOn(component.closeAdvancedFilter, 'emit');
    component.close()
    expect(spy).toHaveBeenCalled();
  });
});
