import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ReactiveFormsModule, FormGroup, FormControl } from '@angular/forms';
import { DropdownModule } from 'primeng/dropdown';
import { DropdownComponent } from './dropdown.component';
import { InputErrorMessageComponent } from '../input-error-message/input-error-message.component';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { MatMenuModule } from '@angular/material/menu';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { TooltipDirective } from '../tooltip/tooltip.directive';
import { ErrorIconComponent } from '../error-icon/error-icon.component';

describe('DropdownComponent', () => {
  let component: DropdownComponent;
  let fixture: ComponentFixture<DropdownComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ReactiveFormsModule, DropdownModule, MatMenuModule],
      declarations: [DropdownComponent, InputErrorMessageComponent, PopoverMenuButtonComponent, IconButtonComponent, ControlLabelComponent, TooltipDirective, ErrorIconComponent]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(DropdownComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display a label if one has been declared', () => {
    component.label = "Test";
    component.ngOnInit();
    fixture.detectChanges();
    expect(component.componentUUID).toContain('test');
  });

  it('should mark the form field as pristine if reset to its initial value and dirty if set to another value', () => {
    component.initialValue = '1';
    component.controlName = 'testControl';
    component.parentForm = new FormGroup({ 'testControl': new FormControl([''])});
    const pristineSpy = spyOn(component.parentForm.get(component.controlName), 'markAsPristine');
    component.ngOnChanges({ value: {previousValue: null, currentValue: '1'} });

    expect(pristineSpy).toHaveBeenCalled();

    const dirtySpy = spyOn(component.parentForm.get(component.controlName), 'markAsDirty');
    component.ngOnChanges({ value: {previousValue: null, currentValue: '2' } });

    expect(dirtySpy).toHaveBeenCalled();
  });
});
