import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ErrorIconComponent } from '../error-icon/error-icon.component';
import { InputErrorMessageComponent } from '../input-error-message/input-error-message.component';

import { DataExceptionMessageComponent } from './data-exception-message.component';
import { DataExceptionMessageType } from './data.interface';

describe('DataExceptionMessageComponent', () => {
  let component: DataExceptionMessageComponent;
  let fixture: ComponentFixture<DataExceptionMessageComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ DataExceptionMessageComponent, InputErrorMessageComponent, ErrorIconComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(DataExceptionMessageComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should render error if error flag is set', () => {
    component.error = true;
    component.message = "Error Message";
    component.messageType = DataExceptionMessageType.error;
    fixture.detectChanges();
    const compiled = fixture.nativeElement;
    const errorMessageElement = compiled.querySelector('span bre-input-error-message .error-message.error');
    expect(errorMessageElement).toBeTruthy();
    expect(errorMessageElement.textContent).toBe('Error Message');
  });

  it('should render success if success flag is set', () => {
    component.error = false;
    component.message = "Success Message";
    component.messageType = DataExceptionMessageType.success;
    fixture.detectChanges();
    const compiled = fixture.nativeElement;
    const errorMessageElement = compiled.querySelector('span bre-input-error-message .error-message.success');
    expect(errorMessageElement).toBeTruthy();
    expect(errorMessageElement.textContent).toBe('Success Message');
  });

  it('should render na if na flag is set', () => {
    component.error = false;
    component.message = "N/A Message";
    component.messageType = DataExceptionMessageType.na;
    fixture.detectChanges();
    const compiled = fixture.nativeElement;
    const errorMessageElement = compiled.querySelector('span bre-input-error-message .error-message.na');
    expect(errorMessageElement).toBeTruthy();
    expect(errorMessageElement.textContent).toBe('N/A Message');
  });

  it('should not render if not error, success or na', () => {
    component.error = false;
    component.message = "None";
    component.messageType = DataExceptionMessageType.none;
    fixture.detectChanges();
    const compiled = fixture.nativeElement;
    const errorMessageElement = compiled.querySelector('span bre-input-error-message');
    expect(errorMessageElement).toBeFalsy();
  });
});
