import { Component } from '@angular/core';

@Component({
  selector: 'bre-core-components',
  templateUrl: './core-components.component.html',
  styleUrls: ['./core-components.component.scss']
})
export class CoreComponentsComponent {

  toggleSwitch = {
    value: true,
    initialValue: true,
  };

  toggleSwitchOff = {
    value: false,
    initialValue: false,
  };

  //BRE Graph - refer https://apexcharts.com/docs/angular-charts/ for complete documentation

  chartOptions = {
    tooltip: {
      custom: (config) => {
        let customtooltip = "";
        let series = config.w.config.series;
        let dIndex = config.dataPointIndex;
        let currentTotal = 0;
        let legend2Total = 0;
        let legend1Total = 0;
        series.forEach((t) => {
          if (t.name === "Legend 1") {
            legend1Total = t.data[dIndex];
          }
          if (t.name === "Legend 2") {
            legend2Total = t.data[dIndex];
          }
          currentTotal += t.data[dIndex];
        });
        customtooltip =
          "<div><span>Total Count: " +
          currentTotal +
          "<br>Legend 1: " +
          legend1Total +
          "<br>Legend 2: " +
          legend2Total +
          "</span></div>";
        return customtooltip;
      },
    },
    noData: {
      text: "No data available",
      align: "center",
      verticalAlign: "middle",
      offsetX: 0,
      offsetY: -25,
      style: {
        color: undefined,
        fontSize: "14px",
        fontFamily: undefined,
      },
    },
    stroke: {
      curve: "straight",
    },
    legend: {
      show: true,
      onItemHover: {
        highlightDataSeries: false,
      },
    },
    series: [
      {
        name: "Legend 1",
        data: [],
        // data: [10, 50, 30, 70, 30, 20, 100, 45]
      },
      {
        name: "Legend 2",
        data: [],
        //data: [4, 12, 8, 17, 9, 10, 20, 15]
      },
    ],
    plotOptions: {
      bar: {
        borderRadius: 7,
        columnWidth: "40%",
      },
    },
    chart: {
      height: 400,
      width: 800,
      type: "bar",
      stacked: "true",
      stackType: "normal", //100%
      toolbar: false,
      animations: { enabled: false },
    },
    title: {
      text: "",
    },
    dataLabels: {
      enabled: false,
      background: {
        borderRadius: 10,
      },
    },
    xaxis: {
      title: { text: "X-Axis Variable" },
      categories: ["X1", "X2", "X3", "X4", "X5", "X6", "X7", "X8"],
    },
    yaxis: {
      title: { text: "Y-Axis Variable" },
    },
    colors: ["#FFBC0D", "#E02020"],
  };

  updateChartData = {
    handleClick: () =>
      (this.chartOptions.series = [
        {
          name: "Legend 1",
          data: [10, 50, 30, 70, 30, 20, 100, 45],
        },
        {
          name: "Legend 2",
          data: [4, 12, 8, 17, 9, 10, 20, 15],
        },
      ]),
  };
}
