import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { ControlLabelComponent } from './control-label.component';
import { MatMenuModule } from '@angular/material/menu';
import { TooltipDirective } from '../tooltip/tooltip.directive';


describe('ControlLabelComponent', () => {
  let component: ControlLabelComponent;
  let fixture: ComponentFixture<ControlLabelComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [MatMenuModule],
      declarations: [ ControlLabelComponent, PopoverMenuButtonComponent, IconButtonComponent, TooltipDirective ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ControlLabelComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });


  it('should display a label for the control if one is declared', () => {
    let compiled = fixture.nativeElement;

    let labelElement = compiled.querySelector('.control-label');
    expect(labelElement).toBeFalsy();

    component.label = "Test";
    fixture.detectChanges();
    compiled = fixture.nativeElement;
    labelElement = compiled.querySelector('.control-label');
    expect(labelElement).toBeTruthy();
    expect(labelElement.textContent).toBe('Test ');
  });
});
