import { Component, EventEmitter, Input, Output } from '@angular/core';
import { TableSortDirection } from '../table/table.component';

@Component({
  selector: 'bre-column-sort-filter',
  templateUrl: './column-sort-filter.component.html',
  styleUrls: ['./column-sort-filter.component.scss']
})
export class ColumnSortFilterComponent {
  @Output() sortDirection = new EventEmitter<TableSortDirection>();
  @Input() activeSortDirection: string;

  initialButtonClasses = {
    asc: 'secondary',
    desc: 'secondary'
  }

  currentButtonClasses: ButtonClasses = this.initialButtonClasses;

  constructor() { }

  ngOnChanges() {
    this.currentButtonClasses = this.setButtonClasses(this.activeSortDirection);
  }

  setSortDirection(direction: string): void {
    this.sortDirection.emit(TableSortDirection[direction]);
  }

  private setButtonClasses(direction: string): ButtonClasses {
    let classes = {...this.initialButtonClasses};
    classes[direction] = 'primary';
    
    return classes;
  }

  clear() {
    this.currentButtonClasses = this.initialButtonClasses;
  }
}

interface ButtonClasses {
  asc: string,
  desc: string
}