import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ButtonModule } from 'primeng/button';
import { ProgressSpinnerModule } from 'primeng/progressspinner';
import { ButtonComponent } from '../button/button.component';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { ColumnSortFilterComponent } from './column-sort-filter.component';

describe('ColumnSortFilterComponent', () => {
  let component: ColumnSortFilterComponent;
  let fixture: ComponentFixture<ColumnSortFilterComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ButtonModule, ProgressSpinnerModule],
      declarations: [ ColumnSortFilterComponent, ButtonComponent, IconButtonComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ColumnSortFilterComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should emit on sort direction', () => {
    spyOn(component.sortDirection, 'emit');
    const direction = 'asc';
    component.setSortDirection(direction);
    expect(component.sortDirection.emit).toHaveBeenCalledWith(direction);
  });

  it('should set the current button classes on changes', () => {
    component.activeSortDirection = 'asc';
    component.ngOnChanges();

    expect(component.currentButtonClasses).toEqual({asc: 'primary', desc: 'secondary'});
  });

  it('should reset to the initial button classes on clear', () => {
    component.currentButtonClasses = {asc: 'primary', desc: 'secondary'};
    component.clear();

    expect(component.currentButtonClasses).toEqual(component.initialButtonClasses);
  });
});
