import { Component, EventEmitter, Input, OnInit, Output, ViewChild } from '@angular/core';
import { AutoCompleteComponent } from '../auto-complete/auto-complete.component';

@Component({
  selector: 'bre-column-search-filter',
  templateUrl: './column-search-filter.component.html',
  styleUrls: ['./column-search-filter.component.scss']
})
export class ColumnSearchFilterComponent {
  @Input() columnData: {[key: string]: string}[];
  @Input() columnName: string;

  @Output() updateSearchFilters = new EventEmitter<any[]>();
  @Output() loadSearchOptions = new EventEmitter<any[]>();

  @ViewChild(AutoCompleteComponent)
  private autoCompleteComponent: AutoCompleteComponent;

  filteredOptions = [];
  currentSearches = [];

  constructor() { }

  loadOptions(query) {
    // const firstEntry = !!query ? { label: `View all results with '${query}'`, value: `${query}` } : { label: undefined, value: undefined }
    // let filteredOptions = this.columnData.filter(x => x.label.toLowerCase().includes(query.toLowerCase()));
    // filteredOptions.unshift(firstEntry);
    // this.filteredOptions = filteredOptions;
    this.emitLoadOptions(query);
  }

  updateSearch(event) {
    this.currentSearches = event.value;
    this.emitUpdatedSearch();
  }
  
  emitUpdatedSearch(): void {
    this.updateSearchFilters.emit(this.currentSearches);
  }

  emitLoadOptions(query): void {
    this.loadSearchOptions.emit([this.columnName, query]);
  }

  clear() {
    this.autoCompleteComponent.clearSelections();
  }
}
