import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { AutoCompleteModule } from 'primeng/autocomplete';
import { CoreModule } from '../../core.module';
import { AutoCompleteComponent } from '../auto-complete/auto-complete.component';

import { ColumnSearchFilterComponent } from './column-search-filter.component';

describe('ColumnSearchFilterComponent', () => {
  let component: ColumnSearchFilterComponent;
  let fixture: ComponentFixture<ColumnSearchFilterComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        CoreModule 
      ],
      declarations: [ 
      ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ColumnSearchFilterComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should assign and emit new current searches', () => {
    spyOn(component, 'emitUpdatedSearch');
    component.updateSearch({value: ['1', '2']});
    fixture.detectChanges();
    expect(component.currentSearches).toEqual(['1','2']);
    expect(component.emitUpdatedSearch).toHaveBeenCalled();
  });

  it('should emit current searches', () => {
    spyOn(component.updateSearchFilters, 'emit');
    component.currentSearches = ['1', '2'];
    component.emitUpdatedSearch();
    fixture.detectChanges();
    expect(component.updateSearchFilters.emit).toHaveBeenCalledWith(component.currentSearches);
  });

  it('should emit when loading options', () => {
    spyOn(component.loadSearchOptions, 'emit');
    component.columnName = 'test';
    component.loadOptions('options');
    expect(component.loadSearchOptions.emit).toHaveBeenCalledWith(['test', 'options']);
  });
});
