import { Input } from "@angular/core";
import { async, ComponentFixture, TestBed } from "@angular/core/testing";
import { FormsModule, ReactiveFormsModule } from "@angular/forms";
import { MatCheckboxModule } from "@angular/material/checkbox";
import { MatMenuModule } from "@angular/material/menu";
import { InputTextModule } from "primeng/inputtext";
import { KeyFilterModule } from "primeng/keyfilter";
import { AutoCompleteModule } from "primeng/autocomplete";
import { ButtonModule } from "primeng/button";
import { CalendarModule } from "primeng/calendar";
import { MultiSelectModule } from "primeng/multiselect";
import { OverlayPanelModule } from "primeng/overlaypanel";
import { ProgressSpinnerModule } from "primeng/progressspinner";
import { AutoCompleteComponent } from "../auto-complete/auto-complete.component";
import { ButtonComponent } from "../button/button.component";
import { CalendarComponent } from "../calendar/calendar.component";
import { ColumnDateFilterComponent } from "../column-date-filter/column-date-filter.component";
import { ColumnCheckboxFilterComponent } from "../column-checkbox-filter/column-checkbox-filter.component";
import { ColumnSearchFilterComponent } from "../column-search-filter/column-search-filter.component";
import { ControlLabelComponent } from "../control-label/control-label.component";
import { IconButtonComponent } from "../icon-button/icon-button.component";
import { InputErrorMessageComponent } from "../input-error-message/input-error-message.component";
import { InputComponent } from "../input/input.component";
import { ColumnSortFilterComponent } from "../column-sort-filter/column-sort-filter.component";
import { ColumnFilterDropdownComponent } from "./column-filter-dropdown.component";
import { PopoverMenuButtonComponent } from "../popover-menu-button/popover-menu-button.component";
import { TooltipDirective } from "../tooltip/tooltip.directive";
import { StatusPillComponent } from "../status-pill/status-pill.component";
import { TableSortDirection } from "../table/table.component";
import { ErrorIconComponent } from "../error-icon/error-icon.component";
import { TimeFilters } from "../filter-table/filter-table.component";

describe("ColumnFilterDropdownComponent", () => {
  let component: ColumnFilterDropdownComponent;
  let fixture: ComponentFixture<ColumnFilterDropdownComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        OverlayPanelModule,
        ButtonModule,
        ProgressSpinnerModule,
        ReactiveFormsModule,
        AutoCompleteModule,
        FormsModule,
        MatCheckboxModule,
        CalendarModule,
        InputTextModule,
        KeyFilterModule,
        MatMenuModule,
        ButtonModule
      ],
      declarations: [
        ColumnFilterDropdownComponent,
        IconButtonComponent,
        ColumnSortFilterComponent,
        ButtonComponent,
        AutoCompleteComponent,
        ColumnSearchFilterComponent,
        ColumnCheckboxFilterComponent,
        ColumnDateFilterComponent,
        InputComponent,
        InputErrorMessageComponent,
        ErrorIconComponent,
        CalendarComponent,
        ControlLabelComponent,
        IconButtonComponent,
        PopoverMenuButtonComponent,
        TooltipDirective,
        StatusPillComponent
      ]
    }).compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ColumnFilterDropdownComponent);
    component = fixture.componentInstance;
    fixture.componentInstance.searchField =
      TestBed.createComponent(InputComponent).componentInstance;
    fixture.detectChanges();
  });

  it("should create", () => {
    expect(component).toBeTruthy();
  });

  it("should applyFilters and unset unappliedFilters", () => {
    const filters = {
      sortDirection: TableSortDirection["asc"],
      searchFilters: []
    };
    spyOn(component.filterUpdate, "emit");
    component.columnName = "value";
    component.unappliedFilters = filters;
    component.applyFilters();
    fixture.detectChanges();
    expect(component.filterUpdate.emit).toHaveBeenCalledWith([
      "value",
      filters,
      "apply",
      false
    ]);
    expect(component.unappliedFilters).toEqual({});
  });

  xit("should clear filters and emit an update", () => {
    spyOn(component.filterUpdate, "emit");
    component.columnName = "value";
    component.clearFilters();
    fixture.detectChanges();
    expect(component.unappliedFilters).toEqual({});
    expect(component.filterUpdate.emit).toHaveBeenCalledWith([
      "value",
      {},
      "clear",
      false
    ]);
  });

  it("should emit an event when a filter is clicked", () => {
    spyOn(component.columnFilterDropdownClick, "emit");
    component.columnName = "value";
    component.onFilterClick({});
    expect(component.columnFilterDropdownClick.emit).toHaveBeenCalledWith(
      component.columnName
    );
  });

  it("should update the unapplied filters when a checkbox selection is changed", () => {
    component.unappliedFilters = { checkboxFilters: null };
    const event = { selection: { example: "test" } };
    component.onCheckboxFilterChange(event);
    expect(component.unappliedFilters.checkboxFilters).toEqual(event.selection);
  });

  it("should update the unapplied filters when a date filter is changed", () => {
    component.unappliedFilters = { timeFilters: null };
    const event: TimeFilters = { dateRange: ["2021-12-12"] };
    component.onDateFilterChange(event);
    expect(component.unappliedFilters.timeFilters).toEqual(event);
  });

  it("should apply a class to active filters on changes", () => {
    const filters = {
      sortDirection: TableSortDirection["asc"],
      searchFilters: []
    };
    component.currentFilters = filters;
    component.ngOnChanges({});
    expect(component.activeClass).toEqual("active-column-filters");

    component.currentFilters = {};
    component.ngOnChanges({});
    expect(component.activeClass).toEqual("");
  });
});
