import { Input } from '@angular/core';
import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { FormsModule, ReactiveFormsModule } from '@angular/forms';
import { InputTextModule } from 'primeng/inputtext';
import { KeyFilterModule } from 'primeng/keyfilter';
import { Calendar, CalendarModule } from 'primeng/calendar';
import { ButtonComponent } from '../button/button.component';
import { CalendarComponent } from '../calendar/calendar.component';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { InputErrorMessageComponent } from '../input-error-message/input-error-message.component';
import { InputComponent } from '../input/input.component';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component';
import { TooltipDirective } from '../tooltip/tooltip.directive';

import { ColumnDateFilterComponent } from './column-date-filter.component';
import { ProgressSpinnerModule } from 'primeng/progressspinner';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { MatMenuModule } from '@angular/material/menu';
import { StatusPillComponent } from '../status-pill/status-pill.component';
import { ColumnCheckboxFilterComponent } from '../column-checkbox-filter/column-checkbox-filter.component';
import { MatCheckboxModule } from '@angular/material/checkbox';
import { ErrorIconComponent } from '../error-icon/error-icon.component';

describe('ColumnDateFilterComponent', () => {
  let component: ColumnDateFilterComponent;
  let fixture: ComponentFixture<ColumnDateFilterComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [
        CalendarModule, 
        ReactiveFormsModule,
        FormsModule,
        InputTextModule,
        KeyFilterModule,
        ProgressSpinnerModule,
        MatMenuModule,
        MatCheckboxModule, 
      ],
      declarations: [ 
        ColumnDateFilterComponent, 
        CalendarComponent, 
        ControlLabelComponent, 
        InputComponent,
        ButtonComponent,
        PopoverMenuButtonComponent,
        TooltipDirective,
        InputErrorMessageComponent,
        ErrorIconComponent,
        IconButtonComponent,
        StatusPillComponent,
        ColumnCheckboxFilterComponent
      ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ColumnDateFilterComponent);
    component = fixture.componentInstance;
    component.columnData = [
      {label: '2021-03-16 08:01:12 GMT', value: '2021-03-16 08:01:12 GMT'},
      {label: '2021-03-18 17:57:49 GMT', value: '2021-03-18 17:57:49 GMT'},
    ]
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should emit an update event when the calendar value is changed', () => {
    const spy = spyOn(component.updateDateFilters, 'emit');
    component.onCalendarValueChange(['2021-03-16 08:01:12 GMT']);

    expect(spy).toHaveBeenCalledWith({dateRange: ['2021-03-16']});

    component.onCalendarValueChange(undefined);

    expect(spy).toHaveBeenCalledWith({dateRange: null});
  });

  it('should reset and emit a new empty value on clear', () => {
    component.currentSelection = {
      dateRange: ['2021-03-16']
    };
    spyOn(component.form, 'reset');
    spyOn(component, 'emitDateFilters');

    fixture.detectChanges;
    component.clear();
    fixture.detectChanges();

    expect(component.form.reset).toHaveBeenCalled();
    expect(component.currentSelection).toEqual({});
    expect(component.emitDateFilters).toHaveBeenCalled();
  });

  it('should emit the current selection as date filters', () => {
    component.currentSelection = {
      dateRange: ['2021-03-16']
    };
    spyOn(component.updateDateFilters, 'emit');
    component.emitDateFilters();
    fixture.detectChanges();
    expect(component.updateDateFilters.emit).toHaveBeenCalledWith(component.currentSelection);
  });

  it('should pick the right times to display in the dropdown', () => {
    const expected = component.availableTimes;
    expect(expected).toEqual([{label: '8 AM', value:'08'},{label: '5 PM', value: '17'}])
  });

  it('should be able to hide the datepicker overlay', () => {
    const spy = spyOn(component.calendar, 'hideOverlay');
    component.closeOverlay();

    expect(spy).toHaveBeenCalled();
  });

  it('should emit an event on list scroll', () => {
    const event = {};
    const spy = spyOn(component.checkboxListScroll, 'emit');
    component.onCheckboxListScroll(event);

    expect(spy).toHaveBeenCalledWith(event);
  });

  it('should emit an event when updating the search field', () => {
    const event = {};
    const spy = spyOn(component.updatedCheckboxSearchField, 'emit');
    component.onUpdatedCheckboxSearchField(event);

    expect(spy).toHaveBeenCalledWith(event);
  });
});
