import {
  Component,
  EventEmitter,
  Input,
  OnChanges,
  OnInit,
  Output,
} from "@angular/core";

@Component({
  selector: "bre-checkbox",
  templateUrl: "./checkbox.component.html",
  styleUrls: ["./checkbox.component.scss"],
})
export class CheckboxComponent implements OnInit {
  @Input() checkboxId: string;
  @Input() checkboxName: string;
  @Input() checkboxChecked: boolean;

  @Output() onCheckboxSelect: EventEmitter<any> = new EventEmitter();
  ngOnInit() {}

  toggleCheckbox(item: any) {
    const emitvalue: icheckbox = {
      checkboxId: item.source.id,
      checkboxName: item.source.name,
      checkboxChecked: item.checked,
    };
    this.onCheckboxSelect.emit(emitvalue);
  }
}

export interface icheckbox {
  checkboxName?: string;
  checkboxId?: string;
  checkboxChecked?: boolean;
}
