import { Component, Input, OnInit } from '@angular/core';
import { v4 as uuid } from 'uuid';

@Component({
  selector: 'bre-card',
  templateUrl: './card.component.html',
  styleUrls: ['./card.component.scss']
})
export class CardComponent implements OnInit {
  @Input() title: string;
  @Input() cardColor: string;
  @Input() cardBorder: string;

  cardUUID: string;

  ngOnInit(): void {
    if (this.title) {
      const parsedLabel = this.title.replace(/\s+/g, '_').toLowerCase();
      this.cardUUID = `${parsedLabel}_${uuid()}`;
    }
  }
}
