import { async, ComponentFixture, TestBed } from '@angular/core/testing';

import { CardComponent } from './card.component';

describe('CardComponent', () => {
  let component: CardComponent;
  let fixture: ComponentFixture<CardComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [ CardComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(CardComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display a title if one is provided', () => {
    let compiled = fixture.nativeElement;
  
    let titleElement = compiled.querySelector('.card-title');
    expect(titleElement).toBeFalsy();

    component.title = "Test";
    component.ngOnInit();
    fixture.detectChanges();
    compiled = fixture.nativeElement;
    titleElement = compiled.querySelector('.card-title');
    expect(titleElement).toBeTruthy();
    expect(titleElement.textContent).toBe('Test');
  });
});
