import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { NoopAnimationsModule } from '@angular/platform-browser/animations';
import { CalendarComponent } from './calendar.component';
import { CalendarModule } from 'primeng/calendar';
import { ReactiveFormsModule, FormGroup, FormControl } from '@angular/forms';
import { ButtonComponent } from '../button/button.component';
import { ProgressSpinnerModule } from 'primeng/progressspinner';
import { ControlLabelComponent } from '../control-label/control-label.component';
import { PopoverMenuButtonComponent } from '../popover-menu-button/popover-menu-button.component';
import { TooltipDirective } from '../tooltip/tooltip.directive';
import { IconButtonComponent } from '../icon-button/icon-button.component';
import { MatMenuModule } from '@angular/material/menu';
import { StatusPillComponent } from '../status-pill/status-pill.component';

describe('CalendarComponent', () => {
  let component: CalendarComponent;
  let fixture: ComponentFixture<CalendarComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      declarations: [CalendarComponent, ButtonComponent, ControlLabelComponent, PopoverMenuButtonComponent, StatusPillComponent, IconButtonComponent, TooltipDirective],
      imports: [ReactiveFormsModule, CalendarModule, ProgressSpinnerModule, NoopAnimationsModule, MatMenuModule]
    })
      .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(CalendarComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should emit single value changed on selection', () => {
    spyOn(component.valueChange, 'emit');

    fixture.nativeElement.querySelector('.ui-calendar input').click();
    fixture.detectChanges();

    const dateCell = fixture.nativeElement.querySelectorAll('.ui-datepicker-calendar td a')[15];
    dateCell.click();
    fixture.detectChanges();

    expect(component.value.getDate().toString()).toEqual(dateCell.textContent);
    expect(component.valueChange.emit).toHaveBeenCalledWith(component.value);
  });

  it('should emit range value changed on selection', () => {
    spyOn(component.valueChange, 'emit');
    component.selectionMode = 'range';

    fixture.nativeElement.querySelector('.ui-calendar input').click();
    fixture.detectChanges();

    const startDateCell = fixture.nativeElement.querySelectorAll('.ui-datepicker-calendar td a')[15];
    startDateCell.click();
    fixture.detectChanges();

    const endDateCell = fixture.nativeElement.querySelectorAll('.ui-datepicker-calendar td a')[19];
    endDateCell.click();
    fixture.detectChanges();

    expect(component.value[0].getDate().toString()).toEqual(startDateCell.textContent);
    expect(component.value[1].getDate().toString()).toEqual(endDateCell.textContent);
    expect(component.valueChange.emit).toHaveBeenCalledWith(component.value);
  });

  it('should reset the parent form value if the input is changed to have no value', () => {
    component.controlName = 'testControl';
    component.parentForm = new FormGroup({ 'testControl': new FormControl([''])});
    const spy = spyOn(component.parentForm, 'reset');
    component.ngOnChanges({ value: { currentValue: undefined} });

    expect(spy).toHaveBeenCalled();
  });

  it('should set the parent form value if the input is changed to have a valid single value', () => {
    component.controlName = 'testControl';
    component.parentForm = new FormGroup({ 'testControl': new FormControl([''])});
    const spy = spyOn(component.parentForm, 'setValue');
    component.ngOnChanges({ value: { currentValue: new Date(2022, 2, 2), previousValue: new Date(2021,1, 1)} });

    expect(spy).toHaveBeenCalled();
  });


  it('should reset the parent form value if the datepicker is cleared', () => {
    component.controlName = 'testControl';
    component.parentForm = new FormGroup({ 'testControl': new FormControl([''])});
    const spy = spyOn(component.parentForm, 'reset');
    component.clearDate();

    expect(spy).toHaveBeenCalled();
  });

  it('should be able to hide the datepicker overlay', () => {
    const spy = spyOn(component.calendar, 'hideOverlay');
    component.hideOverlay();

    expect(spy).toHaveBeenCalled();
  });

  it('should emit a select event on update if configured to do so', () => {
    component.isSelectable = true;
    const spy = spyOn(component.calendarSelected, 'emit');
    component.updateValue();

    expect(spy).toHaveBeenCalled();
  });
});
