import { Component, OnInit } from '@angular/core';
import { FormBuilder, Validators } from '@angular/forms';
import { ToastService } from '../../services/toast/toast.service';
import { DefaultKeyFilters } from '../input/input.component';

@Component({
  selector: 'bre-calendar-page',
  templateUrl: './calendar-page.component.html',
  styleUrls: ['./calendar-page.component.scss']
})
export class CalendarPageComponent implements OnInit {

  breadcrumbs = {
    items: [
      { label: "Essentials", url: "/sandbox/basics" },
      { label: "Input Fields", url: "/sandbox/calendar" }
    ],
  };

  calendar = {
    singleValue: null,
    rangeValue: null,
    effectiveDateValue: null,
    currentSelected: null,
    minDate: null,
    calendarSelected: (event) => {
      this.calendar.currentSelected = "Effective Date";
    },
    singleValueChange: (event) => console.log("calendar single value", event),
    rangeValueChange: (event) => console.log("calendar range value", event),
    effectiveDateChange: (event) =>
      console.log("calendar effective Date change", event),
    _init: () => {
      const today = new Date();
      const afterTomorrow = new Date();
      afterTomorrow.setDate(today.getDate() + 2);
      this.calendar.singleValue = afterTomorrow;
      this.calendar.rangeValue = [today, afterTomorrow];
      this.calendar.effectiveDateValue = new Date();
      this.calendar.minDate = new Date();
    },
    reset: () => {
      this.calendar.effectiveDateValue = this.calendar.minDate;
    },
  };

  monthCalendar = {
    dateformat: null,
    monthValue: null,
    monthValueChange: (event) => {
      console.log("calendar month value", event);
      const month = new Date(event);
      this.monthCalendar.monthValue = month;
    },
    _init: () => {
      const today = new Date();
      this.monthCalendar.monthValue = today;
    },
  };
  dropdown = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    value: "2",
    initialValue: "2",
  };

  form = {
    formGroup: null,
    reset: () => {
      this.form.formGroup.enable();
      this.form.formGroup.reset();
    },
    value: "123",
    disable: () => this.form.formGroup.disable(),
    stringify: () => JSON.stringify(this.form.formGroup.value),
    onFocusOut: true,
    _init: () => {
      this.form.formGroup = this.fb.group({
        dropdown: "2",
        input: "form input",
        multiSelect: { value: [2, 3], disabled: false },
        searchableSelect: ["2", Validators.required],
        initialValue: "2",
        toggleSwitch: true,
      });
      this.form.formGroup?.valueChanges.subscribe((changes) => {
        this.form.formGroup.value = { ...changes };
      });
    },
    inputChanged: (event) => {
      this.form.value = event.value;
    },
    inputfocusedout: (event) => {
      this.form.value = event.value;
    },
    parentFormChanged: ($event) => {
      if ("isPristine" in $event) {
        $event.isPristine
          ? this.form.formGroup.get($event.controlName).markAsPristine()
          : this.form.formGroup.get($event.controlName).markAsDirty();
      }
      this.form.formGroup.controls[$event.controlName].setValue($event.value);
    },
  };

  input = {
    exampleRegex: DefaultKeyFilters.num,
    value: "saf fds",
  };

  inputError = {
    exampleRegex: DefaultKeyFilters.num,
    value: "",
    hasError: (value) => !value,
  };

  multiSelect = {
    items: [
      { label: "Item 1", value: 1 },
      { label: "Item 2", value: 2 },
      { label: "Item 3", value: 3 },
    ],
    selectedItems: [1, 2],
    initialValue: [1, 2],
  };

  searchable = {
    items: [
      { label: "Item 1", value: "1" },
      { label: "Item 2", value: "2" },
    ],
    value: "1",
    initialValue: "1",
    parentFormChanged: ($event) => {
      this.searchable.value = $event.value;
    },
  };

  popover = {
    toast: {
      menuItems: [
        {
          label: "Item 1",
          action: () => this.toastService.success("Item 1 selected"),
        },
        {
          label: "Item 2",
          action: () => this.toastService.success("Item 2 selected"),
        },
      ],
    },
    valueChange: {
      value: 0,
      menuItems: [
        {
          label: "Item 1",
          action: () => {
            this.popover.valueChange.value = 1;
          },
        },
        {
          label: "Item 2",
          action: () => {
            this.popover.valueChange.value = 2;
          },
        },
        {
          label: "Item 3",
          action: () => {
            this.popover.valueChange.value = 3;
          },
        },
      ],
    },
    dropdown: {
      menuItems: [
        {
          label: "Add New Option",
          action: () => {
            const newValue = this.dropdown.items.length + 1;
            this.dropdown.items.push({
              label: `Item ${newValue}`,
              value: newValue.toString(),
            });
          },
        },
      ],
    },
    multiSelect: {
      menuItems: [
        {
          label: "Add New Option",
          action: () => {
            const newValue = this.multiSelect.items.length + 1;
            this.multiSelect.items.push({
              label: `Item ${newValue}`,
              value: newValue,
            });
          },
        },
      ],
    },
    searchable: {
      menuItems: [
        {
          label: "Add New Option",
          action: () => {
            const newValue = this.searchable.items.length + 1;
            this.searchable.items.push({
              label: `Item ${newValue}`,
              value: newValue.toString(),
            });
          },
        },
      ],
    },
  };

  searchableSelectValue = [{
    checked: false,
    label: "Atlanta Region",
    marketIndex: 0,
    regionIndex: 0,
    value: "Atlanta Region"
  }, {
    checked: false,
    label: "BWR Region",
    marketIndex: 0,
    regionIndex: 1,
    value: "BWR Region"
  },{
    checked: false,
    label: "Boston Region",
    marketIndex: 0,
    regionIndex: 2,
    value: "Boston Region"
  }]
  constructor(private fb: FormBuilder, private toastService: ToastService,
  ) { }

  ngOnInit(): void {
  }

}
