import { async, ComponentFixture, TestBed } from '@angular/core/testing';
import { ButtonModule } from 'primeng/button';
import { ProgressSpinnerModule } from 'primeng/progressspinner';

import { ButtonComponent } from './button.component';

describe('ButtonComponent', () => {
  let component: ButtonComponent;
  let fixture: ComponentFixture<ButtonComponent>;

  beforeEach(async(() => {
    TestBed.configureTestingModule({
      imports: [ ButtonModule, ProgressSpinnerModule ],
      declarations: [ ButtonComponent ]
    })
    .compileComponents();
  }));

  beforeEach(() => {
    fixture = TestBed.createComponent(ButtonComponent);
    component = fixture.componentInstance;
    fixture.detectChanges();
  });

  it('should create', () => {
    expect(component).toBeTruthy();
  });

  it('should display a custom label for the button if one is declared', () => {
    let compiled = fixture.nativeElement;
  
    let labelElement = compiled.querySelector('.ui-button-text');
    expect(labelElement).toBeTruthy();
    expect(labelElement.textContent).toBe('Click');

    component.label = 'Test';
    fixture.detectChanges();
    compiled = fixture.nativeElement;
    labelElement = compiled.querySelector('.ui-button-text');
    expect(labelElement).toBeTruthy();
    expect(labelElement.textContent).toBe('Test');
  });

  it('should display a spinner inside the button when in a loading state', () => {
    let compiled = fixture.nativeElement;
  
    let spinnerElement = compiled.querySelector('p-progressspinner');
    expect(spinnerElement).toBeFalsy();

    component.isLoading = true;
    fixture.detectChanges();
    compiled = fixture.nativeElement;
    spinnerElement = compiled.querySelector('p-progressspinner');
    expect(spinnerElement).toBeTruthy();
  });
});
